/*
 * Decompiled with CFR 0.152.
 */
package com.syusuke.commonadapter.recyclerview.wrapper;

import android.view.View;
import android.view.ViewGroup;
import androidx.collection.SparseArrayCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.syusuke.commonadapter.recyclerview.base.ViewHolder;
import com.syusuke.commonadapter.recyclerview.utils.WrapperUtils;

public class HeaderAndFooterWrapper<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int BASE_ITEM_TYPE_HEADER = 100000;
    private static final int BASE_ITEM_TYPE_FOOTER = 200000;
    private SparseArrayCompat<View> mHeaderViews = new SparseArrayCompat();
    private SparseArrayCompat<View> mFootViews = new SparseArrayCompat();
    private RecyclerView.Adapter mInnerAdapter;

    public HeaderAndFooterWrapper(RecyclerView.Adapter adapter) {
        this.mInnerAdapter = adapter;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mHeaderViews.get(viewType) != null) {
            ViewHolder holder = ViewHolder.createViewHolder(parent.getContext(), (View)this.mHeaderViews.get(viewType));
            return holder;
        }
        if (this.mFootViews.get(viewType) != null) {
            ViewHolder holder = ViewHolder.createViewHolder(parent.getContext(), (View)this.mFootViews.get(viewType));
            return holder;
        }
        return this.mInnerAdapter.onCreateViewHolder(parent, viewType);
    }

    public int getItemViewType(int position) {
        if (this.isHeaderViewPos(position)) {
            return this.mHeaderViews.keyAt(position);
        }
        if (this.isFooterViewPos(position)) {
            return this.mFootViews.keyAt(position - this.getHeadersCount() - this.getRealItemCount());
        }
        return this.mInnerAdapter.getItemViewType(position - this.getHeadersCount());
    }

    private int getRealItemCount() {
        return this.mInnerAdapter.getItemCount();
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.isHeaderViewPos(position)) {
            return;
        }
        if (this.isFooterViewPos(position)) {
            return;
        }
        this.mInnerAdapter.onBindViewHolder(holder, position - this.getHeadersCount());
    }

    public int getItemCount() {
        return this.getHeadersCount() + this.getFootersCount() + this.getRealItemCount();
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        WrapperUtils.onAttachedToRecyclerView(this.mInnerAdapter, recyclerView, new WrapperUtils.SpanSizeCallback(){

            @Override
            public int getSpanSize(GridLayoutManager layoutManager, GridLayoutManager.SpanSizeLookup oldLookup, int position) {
                int viewType = HeaderAndFooterWrapper.this.getItemViewType(position);
                if (HeaderAndFooterWrapper.this.mHeaderViews.get(viewType) != null) {
                    return layoutManager.getSpanCount();
                }
                if (HeaderAndFooterWrapper.this.mFootViews.get(viewType) != null) {
                    return layoutManager.getSpanCount();
                }
                if (oldLookup != null) {
                    return oldLookup.getSpanSize(position);
                }
                return 1;
            }
        });
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        this.mInnerAdapter.onViewAttachedToWindow(holder);
        int position = holder.getLayoutPosition();
        if (this.isHeaderViewPos(position) || this.isFooterViewPos(position)) {
            WrapperUtils.setFullSpan(holder);
        }
    }

    private boolean isHeaderViewPos(int position) {
        return position < this.getHeadersCount();
    }

    private boolean isFooterViewPos(int position) {
        return position >= this.getHeadersCount() + this.getRealItemCount();
    }

    public void addHeaderView(View view) {
        this.mHeaderViews.put(this.mHeaderViews.size() + 100000, (Object)view);
    }

    public void addFootView(View view) {
        this.mFootViews.put(this.mFootViews.size() + 200000, (Object)view);
    }

    public int getHeadersCount() {
        return this.mHeaderViews.size();
    }

    public int getFootersCount() {
        return this.mFootViews.size();
    }
}

