/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.exception.UnableToCreateDirectoryException;
import com.kobylynskyi.graphql.codegen.model.exception.UnableToDeleteDirectoryException;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;

public final class Utils {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private Utils() {
    }

    public static boolean isGraphqlOperation(String typeDef) {
        String typeDefNormalized = typeDef.toUpperCase();
        return typeDefNormalized.equals(GraphQLOperation.QUERY.name()) || typeDefNormalized.equals(GraphQLOperation.MUTATION.name()) || typeDefNormalized.equals(GraphQLOperation.SUBSCRIPTION.name());
    }

    public static String capitalize(String stringToCapitalize) {
        char[] chars = stringToCapitalize.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String camelCaseString(String stringToCamelCase) {
        char[] chars = stringToCamelCase.toLowerCase().toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(chars[i]) && chars[i] != '-' && chars[i] != '_' && chars[i] != '.') continue;
            found = false;
        }
        return String.valueOf(chars);
    }

    public static String unCapitalize(String stringToUncapitalize) {
        char[] chars = stringToUncapitalize.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static boolean isNotBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean stringsEqualIgnoreSpaces(String a, String b) {
        return Objects.equals(a, b) || Utils.isBlank(a) && Utils.isBlank(b);
    }

    public static String getFileContent(String filePath) throws IOException {
        return new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
    }

    public static void deleteDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File subFile : files) {
                if (subFile.isDirectory()) {
                    Utils.deleteDir(subFile);
                    continue;
                }
                try {
                    Files.delete(subFile.toPath());
                }
                catch (IOException e) {
                    throw new UnableToDeleteDirectoryException(e);
                }
            }
        }
        try {
            Files.delete(dir.toPath());
        }
        catch (IOException e) {
            throw new UnableToDeleteDirectoryException(e);
        }
    }

    public static void createDirIfAbsent(File dir) {
        if (dir.exists()) {
            return;
        }
        try {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UnableToCreateDirectoryException(dir.getName(), e);
        }
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static String replaceLeadingAtSign(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("^@+", "");
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String wrapString(String str, String wrapWith) {
        return Utils.wrapString(str, wrapWith, wrapWith);
    }

    public static String wrapString(String str, String wrapStart, String wrapEnd) {
        if (str == null || wrapStart == null || wrapEnd == null) {
            return str;
        }
        return wrapStart + str + wrapEnd;
    }

    public static String getFieldVisibility(MappingContext mappingContext) {
        return Boolean.TRUE.equals(mappingContext.isGenerateModelsWithPublicFields()) ? "public" : "private";
    }
}

