/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model.graphql;

import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLResponseField;
import com.kobylynskyi.graphql.codegen.model.graphql.Pair;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public abstract class GraphQLResponseProjection {
    protected final Map<Pair<String, String>, GraphQLResponseField> fields = new LinkedHashMap<Pair<String, String>, GraphQLResponseField>();

    protected GraphQLResponseProjection() {
    }

    protected GraphQLResponseProjection(GraphQLResponseProjection projection) {
        if (projection == null) {
            return;
        }
        projection.fields.values().forEach(this::add$);
    }

    protected GraphQLResponseProjection(List<? extends GraphQLResponseProjection> projections) {
        if (projections == null) {
            return;
        }
        for (GraphQLResponseProjection graphQLResponseProjection : projections) {
            if (graphQLResponseProjection == null) continue;
            graphQLResponseProjection.fields.values().forEach(this::add$);
        }
    }

    public abstract GraphQLResponseProjection deepCopy$();

    protected void add$(GraphQLResponseField responseField) {
        Pair<String, String> nameAndAlias = new Pair<String, String>(responseField.getName(), responseField.getAlias());
        GraphQLResponseField existingResponseField = this.fields.get(nameAndAlias);
        if (existingResponseField == null) {
            this.fields.put(nameAndAlias, responseField.deepCopy());
            return;
        }
        if (!Objects.equals(responseField.getParameters(), existingResponseField.getParameters())) {
            throw new IllegalArgumentException(String.format("Field '%s' has an argument conflict", existingResponseField.getName()));
        }
        if (responseField.getAlias() != null) {
            existingResponseField.alias(responseField.getAlias());
        }
        if (responseField.getParameters() != null) {
            existingResponseField.parameters(responseField.getParameters().deepCopy());
        }
        if (responseField.getProjection() != null) {
            GraphQLResponseProjection projectionCopy = responseField.getProjection().deepCopy$();
            if (existingResponseField.getProjection() != null) {
                for (GraphQLResponseField field : projectionCopy.fields.values()) {
                    existingResponseField.getProjection().add$(field);
                }
            } else {
                existingResponseField.projection(projectionCopy);
            }
        }
    }

    public String toString() {
        if (this.fields.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(" ", "{ ", " }");
        for (GraphQLResponseField value : this.fields.values()) {
            joiner.add(value.toString());
        }
        return joiner.toString();
    }
}

