/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.AnnotationsMapper;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.ValueMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.builders.DeprecatedDefinitionBuilder;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.InputValueDefinition;
import graphql.language.NamedNode;
import graphql.language.Type;
import java.util.List;
import java.util.stream.Collectors;

public class InputValueDefinitionToParameterMapper {
    private final ValueMapper valueMapper;
    private final GraphQLTypeMapper graphQLTypeMapper;
    private final AnnotationsMapper annotationsMapper;
    private final DataModelMapper dataModelMapper;

    public InputValueDefinitionToParameterMapper(MapperFactory mapperFactory) {
        this.valueMapper = mapperFactory.getValueMapper();
        this.graphQLTypeMapper = mapperFactory.getGraphQLTypeMapper();
        this.annotationsMapper = mapperFactory.getAnnotationsMapper();
        this.dataModelMapper = mapperFactory.getDataModelMapper();
    }

    public List<ParameterDefinition> map(MappingContext mappingContext, List<InputValueDefinition> valueDefinitions, String parentTypeName) {
        return valueDefinitions.stream().map(inputValueDef -> this.map(mappingContext, (InputValueDefinition)inputValueDef, parentTypeName)).collect(Collectors.toList());
    }

    private ParameterDefinition map(MappingContext mappingContext, InputValueDefinition inputValueDefinition, String parentTypeName) {
        NamedDefinition namedDefinition = this.graphQLTypeMapper.getLanguageType(mappingContext, inputValueDefinition.getType(), inputValueDefinition.getName(), parentTypeName);
        ParameterDefinition parameter = new ParameterDefinition();
        parameter.setName(this.dataModelMapper.capitalizeIfRestricted(mappingContext, inputValueDefinition.getName()));
        parameter.setOriginalName(inputValueDefinition.getName());
        parameter.setType(this.graphQLTypeMapper.getTypeConsideringPrimitive(mappingContext, namedDefinition, namedDefinition.getJavaName()));
        parameter.setDefaultValue(this.valueMapper.map(mappingContext, inputValueDefinition.getDefaultValue(), inputValueDefinition.getType()));
        parameter.setVisibility(Utils.getFieldVisibility(mappingContext));
        parameter.setAnnotations(this.annotationsMapper.getAnnotations(mappingContext, (Type<?>)inputValueDefinition.getType(), (NamedNode<?>)inputValueDefinition, parentTypeName, false));
        parameter.setDeprecated(DeprecatedDefinitionBuilder.build(mappingContext, inputValueDefinition));
        parameter.setMandatory(namedDefinition.isMandatory());
        parameter.setSerializeUsingObjectMapper(namedDefinition.isSerializeUsingObjectMapper());
        parameter.setGetterMethodName(this.dataModelMapper.capitalizeMethodNameIfRestricted(mappingContext, "get" + Utils.capitalize(inputValueDefinition.getName())));
        return parameter;
    }
}

