/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.java;

import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaGraphQLTypeMapper
extends GraphQLTypeMapper {
    public static final String JAVA_UTIL_LIST = "java.util.List";
    public static final Pattern JAVA_UTIL_LIST_ELEMENT_REGEX = Pattern.compile("java\\.util\\.List<(.+)>");
    private static final String JAVA_UTIL_OPTIONAL = "java.util.Optional";
    private static final Set<String> JAVA_PRIMITIVE_TYPES = new HashSet<String>(Arrays.asList("byte", "short", "int", "long", "float", "double", "char", "boolean"));

    public static boolean isJavaPrimitive(String possiblyPrimitiveType) {
        return JAVA_PRIMITIVE_TYPES.contains(possiblyPrimitiveType);
    }

    @Override
    public String wrapIntoList(MappingContext mappingContext, String type, boolean mandatory) {
        return this.getGenericsString(mappingContext, JAVA_UTIL_LIST, type);
    }

    @Override
    public String wrapSuperTypeIntoList(MappingContext mappingContext, String type, boolean mandatory) {
        return this.getGenericsString(mappingContext, JAVA_UTIL_LIST, "? extends " + type);
    }

    @Override
    public String wrapApiReturnTypeIfRequired(MappingContext mappingContext, NamedDefinition namedDefinition, String parentTypeName) {
        String computedTypeName = namedDefinition.getJavaName();
        if (parentTypeName.equalsIgnoreCase(GraphQLOperation.SUBSCRIPTION.name()) && Utils.isNotBlank(mappingContext.getSubscriptionReturnType())) {
            return this.getGenericsString(mappingContext, mappingContext.getSubscriptionReturnType(), computedTypeName);
        }
        if (Boolean.TRUE.equals(mappingContext.getUseOptionalForNullableReturnTypes()) && !namedDefinition.isMandatory() && !computedTypeName.startsWith(JAVA_UTIL_LIST)) {
            computedTypeName = this.getGenericsString(mappingContext, JAVA_UTIL_OPTIONAL, computedTypeName);
        }
        if (computedTypeName.startsWith(JAVA_UTIL_LIST) && Utils.isNotBlank(mappingContext.getApiReturnListType())) {
            if (mappingContext.getApiReturnListType().contains("{{TYPE}}")) {
                Matcher matcher = JAVA_UTIL_LIST_ELEMENT_REGEX.matcher(computedTypeName);
                if (matcher.find()) {
                    String listElement = matcher.group(1);
                    return mappingContext.getApiReturnListType().replace("{{TYPE}}", listElement);
                }
                throw new IllegalStateException();
            }
            return computedTypeName.replace(JAVA_UTIL_LIST, mappingContext.getApiReturnListType());
        }
        if (Utils.isNotBlank(mappingContext.getApiReturnType())) {
            if (mappingContext.getApiReturnType().contains("{{TYPE}}")) {
                return mappingContext.getApiReturnType().replace("{{TYPE}}", computedTypeName);
            }
            return this.getGenericsString(mappingContext, mappingContext.getApiReturnType(), computedTypeName);
        }
        return this.getTypeConsideringPrimitive(mappingContext, namedDefinition, computedTypeName);
    }

    @Override
    public boolean isPrimitive(String possiblyPrimitiveType) {
        return JavaGraphQLTypeMapper.isJavaPrimitive(possiblyPrimitiveType);
    }

    @Override
    public NamedDefinition getLanguageType(MappingContext mappingContext, String graphQLType, String name, String parentTypeName, boolean mandatory, boolean collection) {
        String langTypeName;
        Map<String, String> customTypesMapping = mappingContext.getCustomTypesMapping();
        Set<String> serializeFieldsUsingObjectMapper = mappingContext.getUseObjectMapperForRequestSerialization();
        boolean primitiveCanBeUsed = !collection;
        boolean serializeUsingObjectMapper = false;
        if (name != null && parentTypeName != null && customTypesMapping.containsKey(parentTypeName + "." + name)) {
            langTypeName = customTypesMapping.get(parentTypeName + "." + name);
            primitiveCanBeUsed = false;
        } else {
            langTypeName = customTypesMapping.containsKey(graphQLType) ? customTypesMapping.get(graphQLType) : DataModelMapper.getModelClassNameWithPrefixAndSuffix(mappingContext, graphQLType);
        }
        if (serializeFieldsUsingObjectMapper.contains(graphQLType) || name != null && parentTypeName != null && serializeFieldsUsingObjectMapper.contains(parentTypeName + "." + name)) {
            serializeUsingObjectMapper = true;
        }
        return new NamedDefinition(langTypeName, graphQLType, this.isInterfaceOrUnion(mappingContext, graphQLType), mandatory, primitiveCanBeUsed, serializeUsingObjectMapper);
    }
}

