/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.generators.impl;

import com.kobylynskyi.graphql.codegen.generators.FilesGenerator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateFilesCreator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.UnionDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedUnionTypeDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UnionGenerator
implements FilesGenerator {
    private final MappingContext mappingContext;
    private final UnionDefinitionToDataModelMapper unionDefinitionToDataModelMapper;

    public UnionGenerator(MappingContext mappingContext, DataModelMapperFactory dataModelMapperFactory) {
        this.mappingContext = mappingContext;
        this.unionDefinitionToDataModelMapper = dataModelMapperFactory.getUnionDefinitionMapper();
    }

    @Override
    public List<File> generate() {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedUnionTypeDefinition definition : this.mappingContext.getDocument().getUnionDefinitions()) {
            generatedFiles.add(this.generate(definition));
        }
        return generatedFiles;
    }

    private File generate(ExtendedUnionTypeDefinition definition) {
        Map<String, Object> dataModel = this.unionDefinitionToDataModelMapper.map(this.mappingContext, definition);
        return FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.UNION, dataModel);
    }
}

