/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.generators.impl;

import com.kobylynskyi.graphql.codegen.generators.FilesGenerator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateFilesCreator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.InterfaceDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInterfaceTypeDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InterfaceGenerator
implements FilesGenerator {
    private final MappingContext mappingContext;
    private final InterfaceDefinitionToDataModelMapper interfaceDefinitionMapper;

    public InterfaceGenerator(MappingContext mappingContext, DataModelMapperFactory dataModelMapperFactory) {
        this.mappingContext = mappingContext;
        this.interfaceDefinitionMapper = dataModelMapperFactory.getInterfaceDefinitionMapper();
    }

    @Override
    public List<File> generate() {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedInterfaceTypeDefinition definition : this.mappingContext.getDocument().getInterfaceDefinitions()) {
            generatedFiles.add(this.generate(definition));
        }
        return generatedFiles;
    }

    private File generate(ExtendedInterfaceTypeDefinition definition) {
        Map<String, Object> dataModel = this.interfaceDefinitionMapper.map(this.mappingContext, definition);
        return FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.INTERFACE, dataModel);
    }
}

