/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.generators.impl;

import com.kobylynskyi.graphql.codegen.generators.FilesGenerator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateFilesCreator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.InputDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInputObjectTypeDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InputGenerator
implements FilesGenerator {
    private final MappingContext mappingContext;
    private final InputDefinitionToDataModelMapper inputDefinitionMapper;

    public InputGenerator(MappingContext mappingContext, DataModelMapperFactory dataModelMapperFactory) {
        this.mappingContext = mappingContext;
        this.inputDefinitionMapper = dataModelMapperFactory.getInputDefinitionMapper();
    }

    @Override
    public List<File> generate() {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedInputObjectTypeDefinition definition : this.mappingContext.getDocument().getInputDefinitions()) {
            generatedFiles.add(this.generate(definition));
        }
        return generatedFiles;
    }

    private File generate(ExtendedInputObjectTypeDefinition definition) {
        Map<String, Object> dataModel = this.inputDefinitionMapper.map(this.mappingContext, definition);
        return FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.TYPE, dataModel);
    }
}

