/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.supplier;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SchemaFinder {
    public static final String DEFAULT_INCLUDE_PATTERN = ".*\\.graphqls?";
    public static final boolean DEFAULT_RECURSIVE = true;
    private final Path rootDir;
    private boolean recursive = true;
    private Pattern includePattern = Pattern.compile(".*\\.graphqls?");
    private Set<Path> excludedFiles = Collections.emptySet();

    public SchemaFinder(Path rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException("rootDir is required for schema search");
        }
        this.rootDir = rootDir;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setIncludePattern(String includePattern) {
        this.includePattern = Pattern.compile(includePattern);
    }

    public void setExcludedFiles(Set<String> excludedFiles) {
        this.excludedFiles = excludedFiles.stream().map(this.rootDir::resolve).collect(Collectors.toSet());
    }

    public List<String> findSchemas() throws IOException {
        int maxDepth = this.recursive ? Integer.MAX_VALUE : 1;
        try (Stream<Path> paths = Files.find(this.rootDir, maxDepth, (path, attrs) -> this.shouldInclude((Path)path), new FileVisitOption[0]);){
            List<String> list = paths.map(Path::toString).sorted().collect(Collectors.toList());
            return list;
        }
    }

    private boolean shouldInclude(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        if (this.excludedFiles.contains(path)) {
            return false;
        }
        String filename = path.getFileName().toString();
        return this.includePattern.matcher(filename).matches();
    }
}

