/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.generators.impl;

import com.kobylynskyi.graphql.codegen.generators.FilesGenerator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateFilesCreator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.RequestResponseDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInterfaceTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ParametrizedInputGenerator
implements FilesGenerator {
    private final MappingContext mappingContext;
    private final RequestResponseDefinitionToDataModelMapper requestResponseDefinitionMapper;

    public ParametrizedInputGenerator(MappingContext mappingContext, DataModelMapperFactory dataModelMapperFactory) {
        this.mappingContext = mappingContext;
        this.requestResponseDefinitionMapper = dataModelMapperFactory.getRequestResponseDefinitionMapper();
    }

    @Override
    public List<File> generate() {
        if (!Boolean.TRUE.equals(this.mappingContext.getGenerateClient())) {
            return Collections.emptyList();
        }
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedInterfaceTypeDefinition extendedInterfaceTypeDefinition : this.mappingContext.getDocument().getInterfaceDefinitions()) {
            generatedFiles.addAll(this.generate(extendedInterfaceTypeDefinition, extendedInterfaceTypeDefinition.getFieldDefinitions()));
        }
        for (ExtendedObjectTypeDefinition extendedObjectTypeDefinition : this.mappingContext.getDocument().getTypeDefinitions()) {
            generatedFiles.addAll(this.generate(extendedObjectTypeDefinition, extendedObjectTypeDefinition.getFieldDefinitions()));
        }
        return generatedFiles;
    }

    private List<File> generate(ExtendedDefinition<?, ?> definition, List<ExtendedFieldDefinition> fieldDefinitions) {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedFieldDefinition fieldDefinition : fieldDefinitions) {
            if (Utils.isEmpty(fieldDefinition.getInputValueDefinitions())) continue;
            File file = this.generate(definition, fieldDefinition);
            generatedFiles.add(file);
        }
        return generatedFiles;
    }

    private File generate(ExtendedDefinition<?, ?> definition, ExtendedFieldDefinition fieldDefinition) {
        Map<String, Object> dataModel = this.requestResponseDefinitionMapper.mapParametrizedInput(this.mappingContext, fieldDefinition, definition);
        return FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.PARAMETRIZED_INPUT, dataModel);
    }
}

