/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.generators.impl;

import com.kobylynskyi.graphql.codegen.generators.FilesGenerator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateFilesCreator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.model.ApiInterfaceStrategy;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import graphql.language.FieldDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OperationsGenerator
implements FilesGenerator {
    private final MappingContext mappingContext;
    private final DataModelMapperFactory dataModelMapperFactory;

    public OperationsGenerator(MappingContext mappingContext, DataModelMapperFactory dataModelMapperFactory) {
        this.mappingContext = mappingContext;
        this.dataModelMapperFactory = dataModelMapperFactory;
    }

    @Override
    public List<File> generate() {
        if (!Boolean.TRUE.equals(this.mappingContext.getGenerateApis())) {
            return Collections.emptyList();
        }
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedObjectTypeDefinition definition : this.mappingContext.getDocument().getOperationDefinitions()) {
            generatedFiles.addAll(this.generateServerOperations(definition));
        }
        return generatedFiles;
    }

    private List<File> generateServerOperations(ExtendedObjectTypeDefinition definition) {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        switch (this.mappingContext.getApiRootInterfaceStrategy()) {
            case INTERFACE_PER_SCHEMA: {
                for (ExtendedObjectTypeDefinition defInFile : definition.groupBySourceLocationFile().values()) {
                    generatedFiles.add(this.generateRootApi(defInFile));
                }
                break;
            }
            case DO_NOT_GENERATE: {
                break;
            }
            default: {
                generatedFiles.add(this.generateRootApi(definition));
            }
        }
        if (this.mappingContext.getApiInterfaceStrategy() == ApiInterfaceStrategy.INTERFACE_PER_OPERATION) {
            List<String> fieldNames = definition.getFieldDefinitions().stream().map(FieldDefinition::getName).collect(Collectors.toList());
            switch (this.mappingContext.getApiNamePrefixStrategy()) {
                case FOLDER_NAME_AS_PREFIX: {
                    for (ExtendedObjectTypeDefinition fileDef : definition.groupBySourceLocationFolder().values()) {
                        generatedFiles.addAll(this.generateApis(fileDef, fieldNames));
                    }
                    break;
                }
                case FILE_NAME_AS_PREFIX: {
                    for (ExtendedObjectTypeDefinition fileDef : definition.groupBySourceLocationFile().values()) {
                        generatedFiles.addAll(this.generateApis(fileDef, fieldNames));
                    }
                    break;
                }
                default: {
                    generatedFiles.addAll(this.generateApis(definition, fieldNames));
                }
            }
        }
        return generatedFiles;
    }

    private List<File> generateApis(ExtendedObjectTypeDefinition definition, List<String> fieldNames) {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedFieldDefinition operationDef : definition.getFieldDefinitions()) {
            Map<String, Object> dataModel = this.dataModelMapperFactory.getFieldDefinitionsToResolverMapper().mapRootTypeField(this.mappingContext, operationDef, definition.getName(), fieldNames);
            generatedFiles.add(FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.OPERATIONS, dataModel));
        }
        return generatedFiles;
    }

    private File generateRootApi(ExtendedObjectTypeDefinition definition) {
        Map<String, Object> dataModel = this.dataModelMapperFactory.getFieldDefinitionsToResolverMapper().mapRootTypeFields(this.mappingContext, definition);
        return FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.OPERATIONS, dataModel);
    }
}

