/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.generators.FilesGenerator;
import com.kobylynskyi.graphql.codegen.generators.FilesGeneratorsFactory;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.MapperFactory;
import com.kobylynskyi.graphql.codegen.model.GeneratedInformation;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.MappingConfigDefaultValuesInitializer;
import com.kobylynskyi.graphql.codegen.model.MappingConfigValidator;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDocument;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedScalarTypeDefinition;
import com.kobylynskyi.graphql.codegen.parser.GraphQLDocumentParser;
import com.kobylynskyi.graphql.codegen.supplier.MappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class GraphQLCodegen {
    protected final MappingConfig mappingConfig;
    private final List<String> schemas;
    private final String introspectionResult;
    private final File outputDir;
    private final GeneratedInformation generatedInformation;
    private final DataModelMapperFactory dataModelMapperFactory;

    protected GraphQLCodegen(List<String> schemas, File outputDir, MappingConfig mappingConfig, GeneratedInformation generatedInformation, MapperFactory mapperFactory) {
        this(schemas, null, outputDir, mappingConfig, null, generatedInformation, mapperFactory);
    }

    protected GraphQLCodegen(String introspectionResult, File outputDir, MappingConfig mappingConfig, GeneratedInformation generatedInformation, MapperFactory mapperFactory) {
        this(null, introspectionResult, outputDir, mappingConfig, null, generatedInformation, mapperFactory);
    }

    protected GraphQLCodegen(List<String> schemas, String introspectionResult, File outputDir, MappingConfig mappingConfig, MappingConfigSupplier externalMappingConfigSupplier, MapperFactory mapperFactory) {
        this(schemas, introspectionResult, outputDir, mappingConfig, externalMappingConfigSupplier, new GeneratedInformation(mappingConfig), mapperFactory);
    }

    protected GraphQLCodegen(List<String> schemas, String introspectionResult, File outputDir, MappingConfig mappingConfig, MappingConfigSupplier externalMappingConfigSupplier, GeneratedInformation generatedInformation, MapperFactory mapperFactory) {
        this.schemas = schemas;
        this.introspectionResult = introspectionResult;
        this.outputDir = outputDir;
        this.generatedInformation = generatedInformation;
        this.dataModelMapperFactory = new DataModelMapperFactory(mapperFactory);
        this.mappingConfig = mappingConfig;
        this.mappingConfig.combine(externalMappingConfigSupplier != null ? (MappingConfig)externalMappingConfigSupplier.get() : null);
        this.initDefaultValues(mappingConfig);
        this.validateConfigs(mappingConfig);
        GraphQLCodegen.sanitizeValues(mappingConfig);
    }

    private static void sanitizeValues(MappingConfig mappingConfig) {
        Map<String, List<String>> directiveAnnotationsMapping;
        Map<String, List<String>> customAnnotationsMapping;
        mappingConfig.setModelValidationAnnotation(Utils.replaceLeadingAtSign(mappingConfig.getModelValidationAnnotation()));
        if (mappingConfig.getResolverArgumentAnnotations() != null) {
            mappingConfig.setResolverArgumentAnnotations(mappingConfig.getResolverArgumentAnnotations().stream().map(Utils::replaceLeadingAtSign).collect(Collectors.toSet()));
        }
        if (mappingConfig.getParametrizedResolverAnnotations() != null) {
            mappingConfig.setParametrizedResolverAnnotations(mappingConfig.getParametrizedResolverAnnotations().stream().map(Utils::replaceLeadingAtSign).collect(Collectors.toSet()));
        }
        if ((customAnnotationsMapping = mappingConfig.getCustomAnnotationsMapping()) != null) {
            for (Map.Entry<String, List<String>> entry : customAnnotationsMapping.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.setValue(entry.getValue().stream().map(Utils::replaceLeadingAtSign).collect(Collectors.toList()));
            }
        }
        if ((directiveAnnotationsMapping = mappingConfig.getDirectiveAnnotationsMapping()) != null) {
            for (Map.Entry<String, List<String>> entry : directiveAnnotationsMapping.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.setValue(entry.getValue().stream().map(Utils::replaceLeadingAtSign).collect(Collectors.toList()));
            }
        }
    }

    protected void initDefaultValues(MappingConfig mappingConfig) {
        MappingConfigDefaultValuesInitializer.initDefaultValues(mappingConfig);
    }

    private void validateConfigs(MappingConfig mappingConfig) {
        MappingConfigValidator.validate(mappingConfig);
    }

    public List<File> generate() throws IOException {
        long startTime = System.currentTimeMillis();
        Utils.deleteDir(this.outputDir);
        Utils.createDirIfAbsent(this.outputDir);
        if (!Utils.isEmpty(this.schemas)) {
            ExtendedDocument document = GraphQLDocumentParser.getDocumentFromSchemas(this.mappingConfig, this.schemas);
            List<File> generatedFiles = this.processDefinitions(document);
            System.out.printf("Finished processing %d schema(s) in %d ms%n", this.schemas.size(), System.currentTimeMillis() - startTime);
            return generatedFiles;
        }
        if (this.introspectionResult != null) {
            ExtendedDocument document = GraphQLDocumentParser.getDocumentFromIntrospectionResult(this.mappingConfig, this.introspectionResult);
            List<File> generatedFiles = this.processDefinitions(document);
            System.out.printf("Finished processing introspection result in %d ms%n", System.currentTimeMillis() - startTime);
            return generatedFiles;
        }
        throw new IllegalArgumentException("Either graphql schema path or introspection result path should be supplied");
    }

    private List<File> processDefinitions(ExtendedDocument document) {
        this.initCustomTypeMappings(document.getScalarDefinitions());
        MappingContext context = MappingContext.builder().setMappingConfig(this.mappingConfig).setOutputDirectory(this.outputDir).setGeneratedInformation(this.generatedInformation).setDataModelMapperFactory(this.dataModelMapperFactory).setDocument(document).build();
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (FilesGenerator generator : FilesGeneratorsFactory.getAll(context, this.dataModelMapperFactory)) {
            generatedFiles.addAll(generator.generate());
        }
        System.out.printf("Generated %d definition classes in folder %s%n", generatedFiles.size(), this.outputDir.getAbsolutePath());
        return generatedFiles;
    }

    protected void initCustomTypeMappings(Collection<ExtendedScalarTypeDefinition> scalarTypeDefinitions) {
        for (ExtendedScalarTypeDefinition definition : scalarTypeDefinitions) {
            if (definition.getDefinition() != null) {
                this.mappingConfig.putCustomTypeMappingIfAbsent(((ScalarTypeDefinition)definition.getDefinition()).getName(), "String");
            }
            for (ScalarTypeExtensionDefinition extension : definition.getExtensions()) {
                this.mappingConfig.putCustomTypeMappingIfAbsent(extension.getName(), "String");
            }
        }
    }
}

