/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.response;

import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonArray;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.json.JsonValue;
import io.github.jopenlibs.vault.json.ParseException;
import io.github.jopenlibs.vault.response.VaultResponse;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class AuthResponse
extends VaultResponse {
    private Boolean renewable;
    private String authClientToken;
    private String tokenAccessor;
    private List<String> authPolicies;
    private long authLeaseDuration;
    private boolean authRenewable;
    private String appId;
    private String userId;
    private String username;
    private String nonce;
    protected JsonObject jsonResponse;

    public AuthResponse(RestResponse restResponse, int retries) {
        super(restResponse, retries);
        try {
            JsonObject authJsonObject;
            String responseJson = new String(restResponse.getBody(), StandardCharsets.UTF_8);
            this.jsonResponse = Json.parse(responseJson).asObject();
            JsonValue authJsonVal = this.jsonResponse.get("auth");
            JsonObject jsonObject = authJsonObject = authJsonVal != null && !authJsonVal.isNull() ? authJsonVal.asObject() : null;
            if (authJsonObject != null) {
                this.authLeaseDuration = authJsonObject.getInt("lease_duration", 0);
                this.authRenewable = authJsonObject.getBoolean("renewable", false);
                if (authJsonObject.get("metadata") != null && !authJsonObject.get("metadata").toString().equalsIgnoreCase("null")) {
                    JsonObject metadata = authJsonObject.get("metadata").asObject();
                    this.appId = metadata.getString("app-id", "");
                    this.userId = metadata.getString("user-id", "");
                    this.username = metadata.getString("username", "");
                    this.nonce = metadata.getString("nonce", "");
                }
                this.authClientToken = authJsonObject.getString("client_token", "");
                this.tokenAccessor = authJsonObject.getString("accessor", "");
                JsonArray authPoliciesJsonArray = authJsonObject.get("policies").asArray();
                this.authPolicies = new ArrayList<String>();
                for (JsonValue authPolicy : authPoliciesJsonArray) {
                    this.authPolicies.add(authPolicy.asString());
                }
            }
            this.renewable = this.jsonResponse.get("renewable").asBoolean();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getUsername() {
        return this.username;
    }

    public Boolean getRenewable() {
        return this.renewable;
    }

    public String getAuthClientToken() {
        return this.authClientToken;
    }

    public List<String> getAuthPolicies() {
        return this.authPolicies;
    }

    public long getAuthLeaseDuration() {
        return this.authLeaseDuration;
    }

    public boolean isAuthRenewable() {
        return this.authRenewable;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getTokenAccessor() {
        return this.tokenAccessor;
    }
}

