/*
 * Decompiled with CFR 0.152.
 */
package io.github.joke.spockmockable.agent;

import io.github.joke.spockmockable.agent.DiscoveryListener;
import io.github.joke.spockmockable.agent.InstallationListener;
import io.github.joke.spockmockable.agent.RedefinitionListener;
import io.github.joke.spockmockable.agent.ReferenceLoader;
import io.github.joke.spockmockable.agent.StaticMockHandler;
import io.github.joke.spockmockable.shadow.javax.inject.Inject;
import io.github.joke.spockmockable.shadow.javax.inject.Singleton;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import lombok.Generated;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.asm.ModifierAdjustment;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.MethodManifestation;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.PackageDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.JavaModule;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.runtime.ByteBuddyInvoker;
import spock.lang.Specification;

@Singleton
public class ClassTransformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassTransformer.class);
    private final ReferenceLoader referenceLoader;
    private final Instrumentation instrumentation;
    private final DiscoveryListener discoveryListener;
    private final InstallationListener installationListener;
    private final RedefinitionListener redefinitionListener;

    public void applyTransformation() {
        log.info("Activating spock-mockable transformation");
        new AgentBuilder.Default(new ByteBuddy().with(TypeValidation.DISABLED)).with((AgentBuilder.PoolStrategy)AgentBuilder.PoolStrategy.Eager.EXTENDED).ignore(x -> !this.safeNeedsTransforming((TypeDescription)x)).with((AgentBuilder.Listener)this.discoveryListener).with((AgentBuilder.InstallationListener)this.installationListener).with((AgentBuilder.InitializationStrategy)AgentBuilder.InitializationStrategy.Minimal.INSTANCE).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)AgentBuilder.RedefinitionStrategy.DiscoveryStrategy.Reiterating.INSTANCE).with((AgentBuilder.RedefinitionStrategy.Listener)this.redefinitionListener).with((AgentBuilder.TypeStrategy)AgentBuilder.TypeStrategy.Default.REDEFINE).type((ElementMatcher)ElementMatchers.any()).transform(this::transform).installOn(this.instrumentation);
    }

    @NotNull
    protected DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, ProtectionDomain protectionDomain) {
        return builder.visit((AsmVisitorWrapper)this.privateClassAdjustment()).visit((AsmVisitorWrapper)this.protectedMethodAdjustment()).visit((AsmVisitorWrapper)this.finalMethodAdjustment()).visit((AsmVisitorWrapper)this.privateFieldAdjustment()).visit((AsmVisitorWrapper)this.staticMethodAdvice());
    }

    @NotNull
    protected AsmVisitorWrapper.ForDeclaredMethods staticMethodAdvice() {
        return new AsmVisitorWrapper.ForDeclaredMethods().method((ElementMatcher)ElementMatchers.isStatic(), new AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper[]{Advice.withCustomMapping().to(StaticMockHandler.class)});
    }

    @NotNull
    protected ModifierAdjustment privateFieldAdjustment() {
        return new ModifierAdjustment().withFieldModifiers((ElementMatcher)ElementMatchers.isPrivate(), new ModifierContributor.ForField[]{FieldManifestation.PLAIN});
    }

    @NotNull
    protected ModifierAdjustment finalMethodAdjustment() {
        return new ModifierAdjustment().withMethodModifiers((ElementMatcher)ElementMatchers.isFinal(), new ModifierContributor.ForMethod[]{MethodManifestation.PLAIN});
    }

    @NotNull
    protected ModifierAdjustment protectedMethodAdjustment() {
        return new ModifierAdjustment().withMethodModifiers((ElementMatcher)ElementMatchers.isPrivate(), new ModifierContributor.ForMethod[]{Visibility.PROTECTED});
    }

    @NotNull
    protected ModifierAdjustment privateClassAdjustment() {
        return new ModifierAdjustment().withTypeModifiers((ElementMatcher)ElementMatchers.isFinal(), new ModifierContributor.ForType[]{TypeManifestation.PLAIN});
    }

    protected boolean safeNeedsTransforming(TypeDescription typeDescription) {
        try {
            return this.needsTransforming(typeDescription);
        }
        catch (TypePool.Resolution.NoSuchTypeException e) {
            return false;
        }
    }

    protected boolean needsTransforming(TypeDescription typeDescription) {
        return !this.isInternal(typeDescription) && (this.classMatches(typeDescription) || this.packageMatches(typeDescription));
    }

    protected boolean classMatches(TypeDescription typeDescription) {
        return this.referenceLoader.getClasses().contains(typeDescription.getName());
    }

    protected boolean packageMatches(TypeDescription typeDescription) {
        PackageDescription packageDescription = typeDescription.getPackage();
        return packageDescription != null && this.referenceLoader.getPackages().contains(packageDescription.getName());
    }

    protected boolean isInternal(TypeDescription typeDescription) {
        return typeDescription.isAssignableTo(ISpockMockObject.class) || typeDescription.isAssignableTo(ByteBuddyInvoker.class) || typeDescription.isAssignableTo(Specification.class);
    }

    @Inject
    @Generated
    public ClassTransformer(ReferenceLoader referenceLoader, Instrumentation instrumentation, DiscoveryListener discoveryListener, InstallationListener installationListener, RedefinitionListener redefinitionListener) {
        this.referenceLoader = referenceLoader;
        this.instrumentation = instrumentation;
        this.discoveryListener = discoveryListener;
        this.installationListener = installationListener;
        this.redefinitionListener = redefinitionListener;
    }
}

