/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil;

import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final byte[] CHARS = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public static boolean isAEnglisChar(String s) {
        if (StringUtil.isEmpty(s)) {
            return true;
        }
        char c = s.charAt(0);
        char i = c;
        return i >= 'A' && i <= 'Z' || i >= 'a' && i <= 'z';
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static boolean isEquals(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 != null) {
            return str1.equals(str2);
        }
        return false;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static int getLengthByByte(String str) {
        int length = 0;
        if (str == null || str.length() == 0) {
            return length;
        }
        for (int i = 0; i < str.length(); ++i) {
            int ascii = Character.codePointAt(str, i);
            if (ascii >= 0 && ascii <= 255) {
                ++length;
                continue;
            }
            length += 2;
        }
        return length;
    }

    public static String subStringByByte(String str, int startPos, int length) {
        if (str == null || str.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int byteLen = 0;
        for (int i = 0; i < str.length(); ++i) {
            int ascii = Character.codePointAt(str, i);
            byteLen = ascii >= 0 && ascii <= 255 ? ++byteLen : (byteLen += 2);
            if (byteLen < startPos + 1 || byteLen > length) break;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static String getRandomString(int length) {
        Random random = new Random(System.currentTimeMillis());
        byte[] randomBytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            randomBytes[i] = CHARS[random.nextInt(CHARS.length)];
        }
        return new String(randomBytes);
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringUtil.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int noOfItems;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if ((noOfItems = endIndex - startIndex) <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static boolean isWhiteSpace(String input) {
        boolean retBool = input.matches("^\\s*$");
        return retBool;
    }

    public static boolean containWhiteSpace(String input) {
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(input);
        boolean found = matcher.find();
        return found;
    }
}

