/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil;

import android.util.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateTimeUtil {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd");

    public static String getYMDHMFormatDateTimeString(Calendar calendar) {
        if (null == calendar) {
            return "";
        }
        return DateTimeUtil.formatDateTimeByCalendar(new SimpleDateFormat("yyyy/MM/dd HH:mm"), calendar);
    }

    public static String getMDHMEFormatDateTimeString(Calendar calendar) {
        if (null == calendar) {
            return "";
        }
        return DateTimeUtil.formatDateTimeByCalendar(new SimpleDateFormat("MM-dd HH:mm E"), calendar);
    }

    public static String getYMDHMFormatDateTimeString(Date date) {
        if (null == date) {
            return "";
        }
        return DateTimeUtil.formatDateTimeByDate(new SimpleDateFormat("yyyy/MM/dd HH:mm"), date);
    }

    public static String getYMDHMSSpetetorFormatDateTimeString(Calendar calendar) {
        if (null == calendar) {
            return "";
        }
        return DateTimeUtil.formatDateTimeByCalendar(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), calendar);
    }

    public static String getHMFormatDateTimeString(Calendar calendar) {
        if (null == calendar) {
            return "";
        }
        return DateTimeUtil.formatDateTimeByCalendar(new SimpleDateFormat("HH:mm"), calendar);
    }

    public static String getHMSFormatDateTimeString(Calendar calendar) {
        if (null == calendar) {
            return "";
        }
        return DateTimeUtil.formatDateTimeByCalendar(new SimpleDateFormat("HH:mm:ss"), calendar);
    }

    public static String formatDateTimeByCalendar(SimpleDateFormat simpleDateFormat, Calendar calendar) {
        if (null == calendar) {
            return "";
        }
        return simpleDateFormat.format(new Date(calendar.getTimeInMillis()));
    }

    public static String formatDateTimeByDate(SimpleDateFormat simpleDateFormat, Date date) {
        if (null == date) {
            return "";
        }
        return simpleDateFormat.format(date);
    }

    public static Date parseDataStr(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String parseAndFormatMDHSStr(String dateStr) {
        if (null == dateStr || dateStr.length() == 0) {
            return "";
        }
        return DateTimeUtil.parseAndFormatDataStr(dateStr, new SimpleDateFormat("MM-dd HH:mm"));
    }

    public static String parseAndFormatDataStr(String dateStr) {
        if (null == dateStr || dateStr.length() == 0) {
            return "";
        }
        return DateTimeUtil.parseAndFormatDataStr(dateStr, new SimpleDateFormat("yyyy/MM/dd HH:mm"));
    }

    public static String parseAndFormatDataStr(String dateStr, SimpleDateFormat simpleDateFormatTarget) {
        if (null == dateStr || dateStr.length() == 0) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (null != date) {
            return simpleDateFormatTarget.format(date);
        }
        return "";
    }

    private static int getMondayPlus(Calendar calendar) {
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 1) {
            return -6;
        }
        return 2 - dayOfWeek;
    }

    public static String getCurrentWeekMonday(Calendar calendar) {
        dateFormat = new SimpleDateFormat("MM/dd");
        return DateTimeUtil.getCurrentWeekMonday(calendar, dateFormat);
    }

    public static String getPreviousSunday(Calendar calendar) {
        dateFormat = new SimpleDateFormat("MM/dd");
        return DateTimeUtil.getPreviousSunday(calendar, dateFormat);
    }

    public static String getCurrentWeekMonday(Calendar calendar, SimpleDateFormat dateFormat) {
        int mondayPlus = DateTimeUtil.getMondayPlus(calendar);
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.setTimeInMillis(calendar.getTimeInMillis());
        currentDate.add(5, mondayPlus);
        Date monday = currentDate.getTime();
        String preMonday = dateFormat.format(monday);
        return preMonday;
    }

    public static String getPreviousSunday(Calendar calendar, SimpleDateFormat dateFormat) {
        int mondayPlus = DateTimeUtil.getMondayPlus(calendar);
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.setTimeInMillis(calendar.getTimeInMillis());
        currentDate.add(5, mondayPlus + 6);
        Date monday = currentDate.getTime();
        String preMonday = dateFormat.format(monday);
        return preMonday;
    }

    public static String getCurrentMonthBeginDate(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        try {
            calendar.set(5, calendar.getActualMinimum(5));
            return dateFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCurrentMonthBeginDate(int year, int month, SimpleDateFormat dateFormat) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        try {
            calendar.set(5, calendar.getActualMinimum(5));
            return dateFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCurrentMonthBeginDate() {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.set(5, calendar.getActualMinimum(5));
            return dateFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCurrentMonthBeginDate(Calendar calendar, SimpleDateFormat dateFormat) {
        try {
            calendar.set(5, calendar.getActualMinimum(5));
            return dateFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCurrentMonthEndDate(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        try {
            calendar.set(5, calendar.getActualMaximum(5));
            return dateFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCurrentMonthEndDate(int year, int month, SimpleDateFormat dateFormat) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        try {
            calendar.set(5, calendar.getActualMaximum(5));
            return dateFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCurrentMonthEndDate() {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.set(5, calendar.getActualMaximum(5));
            return dateFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCurrentMonthEndDate(Calendar calendar, SimpleDateFormat dateFormat) {
        try {
            calendar.set(5, calendar.getActualMaximum(5));
            return dateFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getBefore7DayDate(Date date) {
        Date newDate = new Date();
        if (null == date) {
            date = new Date();
        } else {
            long newTimeMill = date.getTime() - 518400000L;
            Log.d((String)"coder", (String)("==date.getTime():==" + date.getTime() + "  =newTimeMill:=" + newTimeMill));
            newDate.setTime(newTimeMill);
        }
        return newDate;
    }

    public static Date after7DayDate(Date date) {
        Date newDate = new Date();
        if (null == date) {
            date = new Date();
        } else {
            long newTimeMill = date.getTime() + 518400000L;
            newDate.setTime(newTimeMill);
        }
        return newDate;
    }

    public static class DatePattern {
        public static final String YMDEPattern = "yyyy/MM/dd E";
        public static final String YMDPattern = "yyyy/MM/dd";
        public static final String YMDHMPattern = "yyyy/MM/dd HH:mm";
        public static final String YMDHMSPattern = "yyyy-MM-dd HH:mm:ss";
        public static final String HMPattern = "HH:mm";
        public static final String HMSPattern = "HH:mm:ss";
        public static final String MDHMPattern = "MM/dd HH:mm";
        public static final String MDHMPattern2 = "MM-dd HH:mm";
        public static final String MDEPattern = "MM-dd E";
        public static final String MDHMEPattern = "MM-dd HH:mm E";
        public static final String MDEHMPattern = "MM-dd E HH:mm";
        public static final String MDEHMPattern2 = "MM/dd E HH:mm";
    }
}

