/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.text.TextUtils;
import com.moyun365.commonutil.log.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CommonUtil {
    public static String getBigNumberStrByPostion(int num) {
        char[] bigNum = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d', '\u5341'};
        StringBuffer sb = new StringBuffer();
        if (num <= 10) {
            sb.append(bigNum[num]);
        } else if (num > 10 && num < 100) {
            if (num % 10 == 0) {
                sb.append(bigNum[num / 10]).append("\u5341");
            } else if (num < 20) {
                sb.append("\u5341").append(bigNum[num % 10]);
            } else {
                sb.append(bigNum[num / 10]).append("\u5341").append(bigNum[num % 10]);
            }
        }
        return sb.append("\u3001").toString();
    }

    public static String secondToTime(int time) {
        String timeStr = null;
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (time <= 0) {
            return "00:00";
        }
        minute = time / 60;
        if (minute < 60) {
            second = time % 60;
            timeStr = CommonUtil.append00(minute) + ":" + CommonUtil.append00(second);
        } else {
            hour = minute / 60;
            if (hour > 99) {
                return "99:59:59";
            }
            second = time - hour * 3600 - (minute %= 60) * 60;
            timeStr = CommonUtil.append00(hour) + ":" + CommonUtil.append00(minute) + ":" + CommonUtil.append00(second);
        }
        return timeStr;
    }

    public static String append00(int value) {
        if (value >= 10) {
            return String.valueOf(value);
        }
        return new StringBuffer("0").append(value).toString();
    }

    public static String getJson(Context context, String fileName) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            AssetManager assetManager = context.getAssets();
            BufferedReader bf = new BufferedReader(new InputStreamReader(assetManager.open(fileName)));
            while ((line = bf.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public static boolean isAfterTargetDate(String targetDate) {
        LogUtil.d("jife", "==isAfterTargetDate=targetDate:=====" + targetDate);
        Calendar calendar = Calendar.getInstance();
        Calendar targetCalendar = Calendar.getInstance();
        try {
            targetCalendar.setTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(targetDate));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (calendar.after(targetCalendar)) {
            LogUtil.d("jife", "===\u5728\u8fd9\u4e4b\u540e=====");
            return true;
        }
        LogUtil.d("jife", "===\u5728\u8fd9\u4e4b\u524d=====");
        return false;
    }

    public static int daysBetween(Date startDate, Date endDate) {
        int days = 0;
        Calendar calst = Calendar.getInstance();
        Calendar caled = Calendar.getInstance();
        calst.setTime(startDate);
        caled.setTime(endDate);
        calst.set(11, 0);
        calst.set(12, 0);
        calst.set(13, 0);
        caled.set(11, 0);
        caled.set(12, 0);
        caled.set(13, 0);
        days = ((int)(caled.getTime().getTime() / 1000L) - (int)(calst.getTime().getTime() / 1000L)) / 3600 / 24;
        return days;
    }

    public static String formatTime(Long ms) {
        Integer ss = 1000;
        Integer mi = ss * 60;
        Integer hh = mi * 60;
        Integer dd = hh * 24;
        Long day = ms / (long)dd.intValue();
        Long hour = (ms - day * (long)dd.intValue()) / (long)hh.intValue();
        Long minute = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue()) / (long)mi.intValue();
        Long second = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue()) / (long)ss.intValue();
        Long milliSecond = ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue() - second * (long)ss.intValue();
        StringBuffer sb = new StringBuffer();
        if (day > 0L) {
            sb.append(day + "\u5929");
        }
        if (hour > 0L) {
            sb.append(hour + "\u5c0f\u65f6");
        }
        if (minute > 0L) {
            sb.append(minute + "\u5206");
        }
        if (second > 0L) {
            sb.append(second + "\u79d2");
        }
        return sb.toString();
    }

    public static String replaceSpanAndP(String str) {
        if (str.contains("<span>")) {
            str = str.replace("<span>", "");
            str = str.replace("</span>", "");
        }
        if (str.contains("<p>")) {
            str = str.replace("<p>", "");
            str = str.replace("</p>", "");
        }
        return str;
    }

    public static boolean checkApkExist(Context context, String packageName) {
        if (packageName == null || "".equals(packageName)) {
            return false;
        }
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(packageName, 8192);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static boolean isStartsWithFile(String imageUrl) {
        if (TextUtils.isEmpty((CharSequence)imageUrl)) {
            return false;
        }
        return imageUrl.startsWith("file://");
    }
}

