/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil.easypermissions;

import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import com.moyun365.commonutil.easypermissions.EasyPermissions;
import com.moyun365.commonutil.easypermissions.RationaleDialogClickListener;
import com.moyun365.commonutil.easypermissions.RationaleDialogConfig;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class RationaleDialogFragment
extends DialogFragment {
    public static final String TAG = "RationaleDialogFragment";
    private EasyPermissions.PermissionCallbacks mPermissionCallbacks;
    private EasyPermissions.RationaleCallbacks mRationaleCallbacks;
    private boolean mStateSaved = false;

    public static RationaleDialogFragment newInstance(@NonNull String positiveButton, @NonNull String negativeButton, @NonNull String rationaleMsg, @StyleRes int theme, int requestCode, @NonNull String[] permissions) {
        RationaleDialogFragment dialogFragment = new RationaleDialogFragment();
        RationaleDialogConfig config = new RationaleDialogConfig(positiveButton, negativeButton, rationaleMsg, theme, requestCode, permissions);
        dialogFragment.setArguments(config.toBundle());
        return dialogFragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (Build.VERSION.SDK_INT >= 17 && this.getParentFragment() != null) {
            if (this.getParentFragment() instanceof EasyPermissions.PermissionCallbacks) {
                this.mPermissionCallbacks = (EasyPermissions.PermissionCallbacks)this.getParentFragment();
            }
            if (this.getParentFragment() instanceof EasyPermissions.RationaleCallbacks) {
                this.mRationaleCallbacks = (EasyPermissions.RationaleCallbacks)this.getParentFragment();
            }
        }
        if (context instanceof EasyPermissions.PermissionCallbacks) {
            this.mPermissionCallbacks = (EasyPermissions.PermissionCallbacks)context;
        }
        if (context instanceof EasyPermissions.RationaleCallbacks) {
            this.mRationaleCallbacks = (EasyPermissions.RationaleCallbacks)context;
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        this.mStateSaved = true;
        super.onSaveInstanceState(outState);
    }

    public void showAllowingStateLoss(FragmentManager manager, String tag) {
        if (Build.VERSION.SDK_INT >= 26 && manager.isStateSaved()) {
            return;
        }
        if (this.mStateSaved) {
            return;
        }
        this.show(manager, tag);
    }

    public void onDetach() {
        super.onDetach();
        this.mPermissionCallbacks = null;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        this.setCancelable(false);
        RationaleDialogConfig config = new RationaleDialogConfig(this.getArguments());
        RationaleDialogClickListener clickListener = new RationaleDialogClickListener(this, config, this.mPermissionCallbacks, this.mRationaleCallbacks);
        return config.createFrameworkDialog((Context)this.getActivity(), clickListener);
    }
}

