/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhipster.config.apidoc;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.domain.Pageable;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ParameterContext;

public class PageableParameterBuilderPlugin
implements OperationBuilderPlugin {
    public static final String DEFAULT_PAGE_NAME = "page";
    public static final String PAGE_TYPE = "query";
    public static final String PAGE_DESCRIPTION = "Page number of the requested page";
    public static final String DEFAULT_SIZE_NAME = "size";
    public static final String SIZE_TYPE = "query";
    public static final String SIZE_DESCRIPTION = "Size of a page";
    public static final String DEFAULT_SORT_NAME = "sort";
    public static final String SORT_TYPE = "query";
    public static final String SORT_DESCRIPTION = "Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. Multiple sort criteria are supported.";
    private final TypeNameExtractor nameExtractor;
    private final TypeResolver resolver;
    private final ResolvedType pageableType;

    public PageableParameterBuilderPlugin(TypeNameExtractor nameExtractor, TypeResolver resolver) {
        this.nameExtractor = nameExtractor;
        this.resolver = resolver;
        this.pageableType = resolver.resolve(Pageable.class, new Type[0]);
    }

    public boolean supports(DocumentationType delimiter) {
        return DocumentationType.SWAGGER_2.equals((Object)delimiter);
    }

    public void apply(OperationContext context) {
        ArrayList parameters = Lists.newArrayList();
        for (ResolvedMethodParameter methodParameter : context.getParameters()) {
            ResolvedType resolvedType = methodParameter.getParameterType();
            if (!this.pageableType.equals((Object)resolvedType)) continue;
            ParameterContext parameterContext = new ParameterContext(methodParameter, new ParameterBuilder(), context.getDocumentationContext(), context.getGenericsNamingStrategy(), context);
            parameters.add(this.createPageParameter(parameterContext));
            parameters.add(this.createSizeParameter(parameterContext));
            parameters.add(this.createSortParameter(parameterContext));
            context.operationBuilder().parameters((List)parameters);
        }
    }

    protected String getPageName() {
        return DEFAULT_PAGE_NAME;
    }

    protected String getSizeName() {
        return DEFAULT_SIZE_NAME;
    }

    protected String getSortName() {
        return DEFAULT_SORT_NAME;
    }

    protected Parameter createPageParameter(ParameterContext context) {
        ModelReference intModel = this.createModelRefFactory(context).apply(this.resolver.resolve(Integer.TYPE, new Type[0]));
        return new ParameterBuilder().name(this.getPageName()).parameterType("query").modelRef(intModel).description(PAGE_DESCRIPTION).build();
    }

    protected Parameter createSizeParameter(ParameterContext context) {
        ModelReference intModel = this.createModelRefFactory(context).apply(this.resolver.resolve(Integer.TYPE, new Type[0]));
        return new ParameterBuilder().name(this.getSizeName()).parameterType("query").modelRef(intModel).description(SIZE_DESCRIPTION).build();
    }

    protected Parameter createSortParameter(ParameterContext context) {
        ModelReference stringModel = this.createModelRefFactory(context).apply(this.resolver.resolve(List.class, new Type[]{String.class}));
        return new ParameterBuilder().name(this.getSortName()).parameterType("query").modelRef(stringModel).allowMultiple(true).description(SORT_DESCRIPTION).build();
    }

    protected Function<ResolvedType, ? extends ModelReference> createModelRefFactory(ParameterContext context) {
        ModelContext modelContext = ModelContext.inputParam((String)context.getGroupName(), (Type)context.resolvedMethodParameter().getParameterType(), (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getGenericNamingStrategy(), (ImmutableSet)context.getIgnorableParameterTypes());
        return ResolvedTypes.modelRefFactory((ModelContext)modelContext, (TypeNameExtractor)this.nameExtractor);
    }

    TypeResolver getResolver() {
        return this.resolver;
    }

    TypeNameExtractor getNameExtractor() {
        return this.nameExtractor;
    }
}

