/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"version", "vectorString", "accessVector", "accessComplexity", "authentication", "confidentialityImpact", "integrityImpact", "availabilityImpact", "baseScore", "exploitability", "remediationLevel", "reportConfidence", "temporalScore", "collateralDamagePotential", "targetDistribution", "confidentialityRequirement", "integrityRequirement", "availabilityRequirement", "environmentalScore"})
@NullMarked
public class CvssV2Data
implements Serializable {
    private static final long serialVersionUID = -3488320581980953116L;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="CVSS Version")
    private Version version;
    @JsonProperty(value="vectorString")
    private String vectorString;
    @JsonProperty(value="accessVector")
    private @Nullable AccessVectorType accessVector;
    @JsonProperty(value="accessComplexity")
    private @Nullable AccessComplexityType accessComplexity;
    @JsonProperty(value="authentication")
    private @Nullable AuthenticationType authentication;
    @JsonProperty(value="confidentialityImpact")
    private @Nullable CiaType confidentialityImpact;
    @JsonProperty(value="integrityImpact")
    private @Nullable CiaType integrityImpact;
    @JsonProperty(value="availabilityImpact")
    private @Nullable CiaType availabilityImpact;
    @JsonProperty(value="baseScore")
    private Double baseScore;
    @JsonProperty(value="baseSeverity")
    private @Nullable String baseSeverity;
    @JsonProperty(value="exploitability")
    private @Nullable ExploitabilityType exploitability;
    @JsonProperty(value="remediationLevel")
    private @Nullable RemediationLevelType remediationLevel;
    @JsonProperty(value="reportConfidence")
    private @Nullable ReportConfidenceType reportConfidence;
    @JsonProperty(value="temporalScore")
    private @Nullable Double temporalScore;
    @JsonProperty(value="collateralDamagePotential")
    private @Nullable CollateralDamagePotentialType collateralDamagePotential;
    @JsonProperty(value="targetDistribution")
    private @Nullable TargetDistributionType targetDistribution;
    @JsonProperty(value="confidentialityRequirement")
    private @Nullable CiaRequirementType confidentialityRequirement;
    @JsonProperty(value="integrityRequirement")
    private @Nullable CiaRequirementType integrityRequirement;
    @JsonProperty(value="availabilityRequirement")
    private @Nullable CiaRequirementType availabilityRequirement;
    @JsonProperty(value="environmentalScore")
    private @Nullable Double environmentalScore;

    @JsonCreator
    public CvssV2Data(@JsonProperty(value="version") Version version, @JsonProperty(value="vectorString") String vectorString, @JsonProperty(value="baseScore") Double baseScore) {
        this.version = version;
        this.vectorString = vectorString;
        this.baseScore = baseScore;
    }

    public CvssV2Data(Version version, String vectorString, @Nullable AccessVectorType accessVector, @Nullable AccessComplexityType accessComplexity, @Nullable AuthenticationType authentication, @Nullable CiaType confidentialityImpact, @Nullable CiaType integrityImpact, @Nullable CiaType availabilityImpact, Double baseScore, @Nullable String baseSeverity, @Nullable ExploitabilityType exploitability, @Nullable RemediationLevelType remediationLevel, @Nullable ReportConfidenceType reportConfidence, @Nullable Double temporalScore, @Nullable CollateralDamagePotentialType collateralDamagePotential, @Nullable TargetDistributionType targetDistribution, @Nullable CiaRequirementType confidentialityRequirement, @Nullable CiaRequirementType integrityRequirement, @Nullable CiaRequirementType availabilityRequirement, @Nullable Double environmentalScore) {
        this(version, vectorString, baseScore);
        this.accessVector = accessVector;
        this.accessComplexity = accessComplexity;
        this.authentication = authentication;
        this.confidentialityImpact = confidentialityImpact;
        this.integrityImpact = integrityImpact;
        this.availabilityImpact = availabilityImpact;
        this.baseSeverity = baseSeverity;
        this.exploitability = exploitability;
        this.remediationLevel = remediationLevel;
        this.reportConfidence = reportConfidence;
        this.temporalScore = temporalScore;
        this.collateralDamagePotential = collateralDamagePotential;
        this.targetDistribution = targetDistribution;
        this.confidentialityRequirement = confidentialityRequirement;
        this.integrityRequirement = integrityRequirement;
        this.availabilityRequirement = availabilityRequirement;
        this.environmentalScore = environmentalScore;
    }

    @JsonProperty(value="version")
    public Version getVersion() {
        return this.version;
    }

    @JsonProperty(value="vectorString")
    public String getVectorString() {
        return this.vectorString;
    }

    @JsonProperty(value="accessVector")
    public @Nullable AccessVectorType getAccessVector() {
        return this.accessVector;
    }

    @JsonProperty(value="accessComplexity")
    public @Nullable AccessComplexityType getAccessComplexity() {
        return this.accessComplexity;
    }

    @JsonProperty(value="authentication")
    public @Nullable AuthenticationType getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="confidentialityImpact")
    public @Nullable CiaType getConfidentialityImpact() {
        return this.confidentialityImpact;
    }

    @JsonProperty(value="integrityImpact")
    public @Nullable CiaType getIntegrityImpact() {
        return this.integrityImpact;
    }

    @JsonProperty(value="availabilityImpact")
    public @Nullable CiaType getAvailabilityImpact() {
        return this.availabilityImpact;
    }

    @JsonProperty(value="baseScore")
    public Double getBaseScore() {
        return this.baseScore;
    }

    @JsonProperty(value="baseSeverity")
    public @Nullable String getBaseSeverity() {
        return this.baseSeverity;
    }

    @JsonProperty(value="exploitability")
    public @Nullable ExploitabilityType getExploitability() {
        return this.exploitability;
    }

    @JsonProperty(value="remediationLevel")
    public @Nullable RemediationLevelType getRemediationLevel() {
        return this.remediationLevel;
    }

    @JsonProperty(value="reportConfidence")
    public @Nullable ReportConfidenceType getReportConfidence() {
        return this.reportConfidence;
    }

    @JsonProperty(value="temporalScore")
    public @Nullable Double getTemporalScore() {
        return this.temporalScore;
    }

    @JsonProperty(value="collateralDamagePotential")
    public @Nullable CollateralDamagePotentialType getCollateralDamagePotential() {
        return this.collateralDamagePotential;
    }

    @JsonProperty(value="targetDistribution")
    public @Nullable TargetDistributionType getTargetDistribution() {
        return this.targetDistribution;
    }

    @JsonProperty(value="confidentialityRequirement")
    public @Nullable CiaRequirementType getConfidentialityRequirement() {
        return this.confidentialityRequirement;
    }

    @JsonProperty(value="integrityRequirement")
    public @Nullable CiaRequirementType getIntegrityRequirement() {
        return this.integrityRequirement;
    }

    @JsonProperty(value="availabilityRequirement")
    public @Nullable CiaRequirementType getAvailabilityRequirement() {
        return this.availabilityRequirement;
    }

    @JsonProperty(value="environmentalScore")
    public @Nullable Double getEnvironmentalScore() {
        return this.environmentalScore;
    }

    public String toString() {
        return "CvssV2Data{version=" + String.valueOf((Object)this.version) + ", vectorString='" + this.vectorString + "', accessVector=" + String.valueOf((Object)this.accessVector) + ", accessComplexity=" + String.valueOf((Object)this.accessComplexity) + ", authentication=" + String.valueOf((Object)this.authentication) + ", confidentialityImpact=" + String.valueOf((Object)this.confidentialityImpact) + ", integrityImpact=" + String.valueOf((Object)this.integrityImpact) + ", availabilityImpact=" + String.valueOf((Object)this.availabilityImpact) + ", baseScore=" + this.baseScore + ", exploitability=" + String.valueOf((Object)this.exploitability) + ", remediationLevel=" + String.valueOf((Object)this.remediationLevel) + ", reportConfidence=" + String.valueOf((Object)this.reportConfidence) + ", temporalScore=" + this.temporalScore + ", collateralDamagePotential=" + String.valueOf((Object)this.collateralDamagePotential) + ", targetDistribution=" + String.valueOf((Object)this.targetDistribution) + ", confidentialityRequirement=" + String.valueOf((Object)this.confidentialityRequirement) + ", integrityRequirement=" + String.valueOf((Object)this.integrityRequirement) + ", availabilityRequirement=" + String.valueOf((Object)this.availabilityRequirement) + ", environmentalScore=" + this.environmentalScore + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvssV2Data cvssV2Data = (CvssV2Data)o;
        return this.version == cvssV2Data.version && Objects.equals(this.vectorString, cvssV2Data.vectorString) && this.accessVector == cvssV2Data.accessVector && this.accessComplexity == cvssV2Data.accessComplexity && this.authentication == cvssV2Data.authentication && this.confidentialityImpact == cvssV2Data.confidentialityImpact && this.integrityImpact == cvssV2Data.integrityImpact && this.availabilityImpact == cvssV2Data.availabilityImpact && Objects.equals(this.baseScore, cvssV2Data.baseScore) && this.exploitability == cvssV2Data.exploitability && this.remediationLevel == cvssV2Data.remediationLevel && this.reportConfidence == cvssV2Data.reportConfidence && Objects.equals(this.temporalScore, cvssV2Data.temporalScore) && this.collateralDamagePotential == cvssV2Data.collateralDamagePotential && this.targetDistribution == cvssV2Data.targetDistribution && this.confidentialityRequirement == cvssV2Data.confidentialityRequirement && this.integrityRequirement == cvssV2Data.integrityRequirement && this.availabilityRequirement == cvssV2Data.availabilityRequirement && Objects.equals(this.environmentalScore, cvssV2Data.environmentalScore);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.vectorString, this.accessVector, this.accessComplexity, this.authentication, this.confidentialityImpact, this.integrityImpact, this.availabilityImpact, this.baseScore, this.exploitability, this.remediationLevel, this.reportConfidence, this.temporalScore, this.collateralDamagePotential, this.targetDistribution, this.confidentialityRequirement, this.integrityRequirement, this.availabilityRequirement, this.environmentalScore});
    }

    public static enum Version {
        _2_0("2.0");

        private static final Map<String, Version> CONSTANTS;
        private final String value;

        private Version(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Version fromValue(String value) {
            Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Version>();
            for (Version c : Version.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AccessVectorType {
        NETWORK("NETWORK"),
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        LOCAL("LOCAL");

        private static final Map<String, AccessVectorType> CONSTANTS;
        private final String value;

        private AccessVectorType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AccessVectorType fromValue(String value) {
            AccessVectorType constant;
            if (value.length() == 1) {
                for (AccessVectorType t : AccessVectorType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AccessVectorType>();
            for (AccessVectorType c : AccessVectorType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AccessComplexityType {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private static final Map<String, AccessComplexityType> CONSTANTS;
        private final String value;

        private AccessComplexityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AccessComplexityType fromValue(String value) {
            AccessComplexityType constant;
            if (value.length() == 1) {
                for (AccessComplexityType t : AccessComplexityType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AccessComplexityType>();
            for (AccessComplexityType c : AccessComplexityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AuthenticationType {
        MULTIPLE("MULTIPLE"),
        SINGLE("SINGLE"),
        NONE("NONE");

        private static final Map<String, AuthenticationType> CONSTANTS;
        private final String value;

        private AuthenticationType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AuthenticationType fromValue(String value) {
            AuthenticationType constant;
            if (value.length() == 1) {
                for (AuthenticationType t : AuthenticationType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AuthenticationType>();
            for (AuthenticationType c : AuthenticationType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CiaType {
        NONE("NONE"),
        PARTIAL("PARTIAL"),
        COMPLETE("COMPLETE");

        private static final Map<String, CiaType> CONSTANTS;
        private final String value;

        private CiaType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CiaType fromValue(String value) {
            CiaType constant;
            if (value.length() == 1) {
                for (CiaType t : CiaType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, CiaType>();
            for (CiaType c : CiaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ExploitabilityType {
        UNPROVEN("UNPROVEN"),
        PROOF_OF_CONCEPT("PROOF_OF_CONCEPT"),
        FUNCTIONAL("FUNCTIONAL"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ExploitabilityType> CONSTANTS;
        private final String value;

        private ExploitabilityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExploitabilityType fromValue(String value) {
            ExploitabilityType constant;
            if (value.length() == 1) {
                for (ExploitabilityType t : ExploitabilityType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ExploitabilityType>();
            for (ExploitabilityType c : ExploitabilityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum RemediationLevelType {
        OFFICIAL_FIX("OFFICIAL_FIX"),
        TEMPORARY_FIX("TEMPORARY_FIX"),
        WORKAROUND("WORKAROUND"),
        UNAVAILABLE("UNAVAILABLE"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, RemediationLevelType> CONSTANTS;
        private final String value;

        private RemediationLevelType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RemediationLevelType fromValue(String value) {
            RemediationLevelType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (RemediationLevelType t : RemediationLevelType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, RemediationLevelType>();
            for (RemediationLevelType c : RemediationLevelType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ReportConfidenceType {
        UNCONFIRMED("UNCONFIRMED"),
        UNCORROBORATED("UNCORROBORATED"),
        CONFIRMED("CONFIRMED"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ReportConfidenceType> CONSTANTS;
        private final String value;

        private ReportConfidenceType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReportConfidenceType fromValue(String value) {
            ReportConfidenceType constant;
            if (value.length() == 1) {
                for (ReportConfidenceType t : ReportConfidenceType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ReportConfidenceType>();
            for (ReportConfidenceType c : ReportConfidenceType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CollateralDamagePotentialType {
        NONE("NONE"),
        LOW("LOW"),
        LOW_MEDIUM("LOW_MEDIUM"),
        MEDIUM_HIGH("MEDIUM_HIGH"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, CollateralDamagePotentialType> CONSTANTS;
        private final String value;

        private CollateralDamagePotentialType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CollateralDamagePotentialType fromValue(String value) {
            CollateralDamagePotentialType constant;
            if (value.length() == 1) {
                for (CollateralDamagePotentialType t : CollateralDamagePotentialType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, CollateralDamagePotentialType>();
            for (CollateralDamagePotentialType c : CollateralDamagePotentialType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum TargetDistributionType {
        NONE("NONE"),
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, TargetDistributionType> CONSTANTS;
        private final String value;

        private TargetDistributionType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TargetDistributionType fromValue(String value) {
            TargetDistributionType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (TargetDistributionType t : TargetDistributionType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, TargetDistributionType>();
            for (TargetDistributionType c : TargetDistributionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CiaRequirementType {
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, CiaRequirementType> CONSTANTS;
        private final String value;

        private CiaRequirementType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CiaRequirementType fromValue(String value) {
            CiaRequirementType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (CiaRequirementType t : CiaRequirementType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, CiaRequirementType>();
            for (CiaRequirementType c : CiaRequirementType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

