/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.ghsa;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.jeremylong.openvulnerability.client.ghsa.AbstractPageable;
import io.github.jeremylong.openvulnerability.client.ghsa.PageInfo;
import io.github.jeremylong.openvulnerability.client.ghsa.RateLimit;
import io.github.jeremylong.openvulnerability.client.ghsa.SecurityAdvisory;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SecurityAdvisories
implements Serializable {
    private static final long serialVersionUID = -7829868528353680425L;
    @JsonProperty(value="data", access=JsonProperty.Access.WRITE_ONLY)
    private Data data;

    @JsonIgnore
    RateLimit getRateLimit() {
        if (this.data == null) {
            return null;
        }
        return this.data.rateLimit;
    }

    public List<SecurityAdvisory> getSecurityAdvisories() {
        if (this.data == null || this.data.securityAdvisories == null) {
            return null;
        }
        return this.data.securityAdvisories.nodes;
    }

    void setSecurityAdvisories(List<SecurityAdvisory> advisories) {
        if (this.data == null) {
            this.data = new Data();
            this.data.securityAdvisories = new Advisories();
        }
        this.data.securityAdvisories.nodes = advisories;
    }

    @JsonIgnore
    PageInfo getPageInfo() {
        if (this.data == null || this.data.securityAdvisories == null) {
            return null;
        }
        return this.data.securityAdvisories.getPageInfo();
    }

    @JsonIgnore
    public int getTotalCount() {
        if (this.data == null || this.data.securityAdvisories == null) {
            return 0;
        }
        return this.data.securityAdvisories.getTotalCount();
    }

    public String toString() {
        if (this.data == null) {
            return "";
        }
        return this.data.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityAdvisories that = (SecurityAdvisories)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Data
    implements Serializable {
        private static final long serialVersionUID = 4441909076655785290L;
        @JsonProperty(value="rateLimit")
        private RateLimit rateLimit;
        @JsonProperty(value="securityAdvisories")
        private Advisories securityAdvisories;

        Data() {
        }

        public String toString() {
            return "Data{rateLimit=" + String.valueOf(this.rateLimit) + ", securityAdvisories=" + String.valueOf(this.securityAdvisories) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Data data = (Data)o;
            return Objects.equals(this.rateLimit, data.rateLimit) && Objects.equals(this.securityAdvisories, data.securityAdvisories);
        }

        public int hashCode() {
            return Objects.hash(this.rateLimit, this.securityAdvisories);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Advisories
    extends AbstractPageable
    implements Serializable {
        private static final long serialVersionUID = 9126577085167634044L;
        @JsonProperty(value="nodes")
        private List<SecurityAdvisory> nodes;

        Advisories() {
        }

        public String toString() {
            return "SecurityAdvisories{nodes=" + String.valueOf(this.nodes) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Advisories that = (Advisories)o;
            return Objects.equals(this.nodes, that.nodes);
        }

        public int hashCode() {
            return Objects.hash(this.nodes);
        }
    }
}

