/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector;

import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.ByteSequence;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.util.List;

public interface VectorUtilSupport {
    public float dotProduct(VectorFloat<?> var1, VectorFloat<?> var2);

    public float dotProduct(VectorFloat<?> var1, int var2, VectorFloat<?> var3, int var4, int var5);

    public float cosine(VectorFloat<?> var1, VectorFloat<?> var2);

    public float cosine(VectorFloat<?> var1, int var2, VectorFloat<?> var3, int var4, int var5);

    public float squareDistance(VectorFloat<?> var1, VectorFloat<?> var2);

    public float squareDistance(VectorFloat<?> var1, int var2, VectorFloat<?> var3, int var4, int var5);

    public VectorFloat<?> sum(List<VectorFloat<?>> var1);

    public float sum(VectorFloat<?> var1);

    public void scale(VectorFloat<?> var1, float var2);

    public void addInPlace(VectorFloat<?> var1, VectorFloat<?> var2);

    public void addInPlace(VectorFloat<?> var1, float var2);

    public void subInPlace(VectorFloat<?> var1, VectorFloat<?> var2);

    public void subInPlace(VectorFloat<?> var1, float var2);

    public VectorFloat<?> sub(VectorFloat<?> var1, VectorFloat<?> var2);

    public VectorFloat<?> sub(VectorFloat<?> var1, float var2);

    public VectorFloat<?> sub(VectorFloat<?> var1, int var2, VectorFloat<?> var3, int var4, int var5);

    public void minInPlace(VectorFloat<?> var1, VectorFloat<?> var2);

    public float assembleAndSum(VectorFloat<?> var1, int var2, ByteSequence<?> var3);

    public float assembleAndSum(VectorFloat<?> var1, int var2, ByteSequence<?> var3, int var4, int var5);

    public float assembleAndSumPQ(VectorFloat<?> var1, int var2, ByteSequence<?> var3, int var4, ByteSequence<?> var5, int var6, int var7);

    public int hammingDistance(long[] var1, long[] var2);

    public void calculatePartialSums(VectorFloat<?> var1, int var2, int var3, int var4, VectorFloat<?> var5, int var6, VectorSimilarityFunction var7, VectorFloat<?> var8);

    public float max(VectorFloat<?> var1);

    public float min(VectorFloat<?> var1);

    default public float pqDecodedCosineSimilarity(ByteSequence<?> encoded, int clusterCount, VectorFloat<?> partialSums, VectorFloat<?> aMagnitude, float bMagnitude) {
        return this.pqDecodedCosineSimilarity(encoded, 0, encoded.length(), clusterCount, partialSums, aMagnitude, bMagnitude);
    }

    default public float pqDecodedCosineSimilarity(ByteSequence<?> encoded, int encodedOffset, int encodedLength, int clusterCount, VectorFloat<?> partialSums, VectorFloat<?> aMagnitude, float bMagnitude) {
        float sum = 0.0f;
        float aMag = 0.0f;
        for (int m = 0; m < encodedLength; ++m) {
            int centroidIndex = Byte.toUnsignedInt(encoded.get(m + encodedOffset));
            int index = m * clusterCount + centroidIndex;
            sum += partialSums.get(index);
            aMag += aMagnitude.get(index);
        }
        return (float)((double)sum / Math.sqrt(aMag * bMagnitude));
    }

    public float nvqDotProduct8bit(VectorFloat<?> var1, ByteSequence<?> var2, float var3, float var4, float var5, float var6);

    public float nvqSquareL2Distance8bit(VectorFloat<?> var1, ByteSequence<?> var2, float var3, float var4, float var5, float var6);

    public float[] nvqCosine8bit(VectorFloat<?> var1, ByteSequence<?> var2, float var3, float var4, float var5, float var6, VectorFloat<?> var7);

    public void nvqShuffleQueryInPlace8bit(VectorFloat<?> var1);

    public void nvqQuantize8bit(VectorFloat<?> var1, float var2, float var3, float var4, float var5, ByteSequence<?> var6);

    public float nvqLoss(VectorFloat<?> var1, float var2, float var3, float var4, float var5, int var6);

    public float nvqUniformLoss(VectorFloat<?> var1, float var2, float var3, int var4);
}

