/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector;

import io.github.jbellis.jvector.disk.IndexWriter;
import io.github.jbellis.jvector.util.RamUsageEstimator;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.io.IOException;
import java.util.Arrays;

public final class ArrayVectorFloat
implements VectorFloat<float[]> {
    private final float[] data;

    ArrayVectorFloat(int length) {
        this.data = new float[length];
    }

    ArrayVectorFloat(float[] data) {
        this.data = data;
    }

    @Override
    public float[] get() {
        return this.data;
    }

    @Override
    public float get(int n) {
        return this.data[n];
    }

    @Override
    public void set(int n, float value) {
        this.data[n] = value;
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, 0.0f);
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public void writeTo(IndexWriter writer) throws IOException {
        writer.writeFloats(this.get(), 0, this.data.length);
    }

    @Override
    public VectorFloat<float[]> copy() {
        return new ArrayVectorFloat(Arrays.copyOf(this.data, this.data.length));
    }

    @Override
    public void copyFrom(VectorFloat<?> src, int srcOffset, int destOffset, int length) {
        ArrayVectorFloat csrc = (ArrayVectorFloat)src;
        System.arraycopy(csrc.data, srcOffset, this.data, destOffset, length);
    }

    @Override
    public long ramBytesUsed() {
        int OH_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        return (long)OH_BYTES + RamUsageEstimator.sizeOf(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < Math.min(this.data.length, 25); ++i) {
            sb.append(this.data[i]);
            if (i >= this.data.length - 1) continue;
            sb.append(", ");
        }
        if (this.data.length > 25) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayVectorFloat that = (ArrayVectorFloat)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return this.getHashCode();
    }
}

