/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.quantization;

import io.github.jbellis.jvector.disk.IndexWriter;
import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.quantization.CompressedVectors;
import io.github.jbellis.jvector.util.PhysicalCoreExecutor;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.io.IOException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.IntStream;

public interface VectorCompressor<T> {
    default public CompressedVectors encodeAll(RandomAccessVectorValues ravv) {
        return this.encodeAll(ravv, PhysicalCoreExecutor.pool());
    }

    public CompressedVectors encodeAll(RandomAccessVectorValues var1, ForkJoinPool var2);

    public T encode(VectorFloat<?> var1);

    public void encodeTo(VectorFloat<?> var1, T var2);

    public void write(IndexWriter var1, int var2) throws IOException;

    default public void write(IndexWriter out) throws IOException {
        this.write(out, 6);
    }

    @Deprecated
    public CompressedVectors createCompressedVectors(Object[] var1);

    public int compressorSize();

    public int compressedVectorSize();

    public double reconstructionError(VectorFloat<?> var1);

    default public double[] reconstructionErrors(RandomAccessVectorValues ravv) {
        return IntStream.range(0, ravv.size()).mapToDouble(i -> this.reconstructionError(ravv.getVector(i))).toArray();
    }

    default public double[] reconstructionErrors(RandomAccessVectorValues ravv, ForkJoinPool simdExecutor) {
        return (double[])((ForkJoinTask)simdExecutor.submit(() -> IntStream.range(0, ravv.size()).mapToDouble(i -> this.reconstructionError(ravv.getVector(i))).toArray())).join();
    }
}

