/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.similarity;

import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.graph.similarity.SearchScoreProvider;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.VectorFloat;

public final class DefaultSearchScoreProvider
implements SearchScoreProvider {
    private final ScoreFunction scoreFunction;
    private final ScoreFunction.ExactScoreFunction reranker;

    public DefaultSearchScoreProvider(ScoreFunction scoreFunction) {
        this(scoreFunction, null);
    }

    public DefaultSearchScoreProvider(ScoreFunction scoreFunction, ScoreFunction.ExactScoreFunction reranker) {
        assert (scoreFunction != null);
        this.scoreFunction = scoreFunction;
        this.reranker = reranker;
    }

    @Override
    public ScoreFunction scoreFunction() {
        return this.scoreFunction;
    }

    @Override
    public ScoreFunction.ExactScoreFunction reranker() {
        return this.reranker;
    }

    @Override
    public ScoreFunction.ExactScoreFunction exactScoreFunction() {
        return this.scoreFunction.isExact() ? (ScoreFunction.ExactScoreFunction)this.scoreFunction : this.reranker;
    }

    public static DefaultSearchScoreProvider exact(final VectorFloat<?> v, final VectorSimilarityFunction vsf, final RandomAccessVectorValues ravv) {
        ScoreFunction.ExactScoreFunction sf = new ScoreFunction.ExactScoreFunction(){

            @Override
            public float similarityTo(int node2) {
                return vsf.compare(v, ravv.getVector(node2));
            }
        };
        return new DefaultSearchScoreProvider(sf);
    }

    public static DefaultSearchScoreProvider exact(final VectorFloat<?> v, final int[] graphToRavvOrdMap, final VectorSimilarityFunction vsf, final RandomAccessVectorValues ravv) {
        ScoreFunction.ExactScoreFunction sf = new ScoreFunction.ExactScoreFunction(){

            @Override
            public float similarityTo(int node2) {
                return vsf.compare(v, ravv.getVector(graphToRavvOrdMap[node2]));
            }
        };
        return new DefaultSearchScoreProvider(sf);
    }
}

