/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.RandomAccessWriter;
import io.github.jbellis.jvector.graph.ImmutableGraphIndex;
import io.github.jbellis.jvector.graph.OnHeapGraphIndex;
import io.github.jbellis.jvector.graph.disk.AbstractGraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.OrdinalMapper;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.IntFunction;

public abstract class RandomAccessOnDiskGraphIndexWriter
extends AbstractGraphIndexWriter<RandomAccessWriter> {
    protected final long startOffset;

    protected RandomAccessOnDiskGraphIndexWriter(RandomAccessWriter randomAccessWriter, int version, long startOffset, ImmutableGraphIndex graph, OrdinalMapper oldToNewOrdinals, int dimension, EnumMap<FeatureId, Feature> features) {
        super(randomAccessWriter, version, graph, oldToNewOrdinals, dimension, features);
        this.startOffset = startOffset;
    }

    @Override
    public synchronized void close() throws IOException {
        ((RandomAccessWriter)this.out).close();
    }

    public RandomAccessWriter getOutput() {
        return (RandomAccessWriter)this.out;
    }

    @Deprecated
    public synchronized void writeInline(int ordinal, Map<FeatureId, Feature.State> stateMap) throws IOException {
        this.writeFeaturesInline(ordinal, stateMap);
    }

    public synchronized void writeFeaturesInline(int ordinal, Map<FeatureId, Feature.State> stateMap) throws IOException {
        for (FeatureId featureId : stateMap.keySet()) {
            if (this.featureMap.containsKey((Object)featureId)) continue;
            throw new IllegalArgumentException(String.format("Feature %s not configured for index", new Object[]{featureId}));
        }
        ((RandomAccessWriter)this.out).seek(this.featureOffsetForOrdinal(ordinal));
        for (Feature feature : this.inlineFeatures) {
            Feature.State state = stateMap.get((Object)feature.id());
            if (state == null) {
                ((RandomAccessWriter)this.out).seek(((RandomAccessWriter)this.out).position() + (long)feature.featureSize());
                continue;
            }
            feature.writeInline(this.out, state);
        }
        this.maxOrdinalWritten = Math.max(this.maxOrdinalWritten, ordinal);
    }

    @Override
    public synchronized void write(Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers) throws IOException {
        Object ohgi;
        if (this.graph instanceof OnHeapGraphIndex && ((OnHeapGraphIndex)(ohgi = (OnHeapGraphIndex)this.graph)).getDeletedNodes().cardinality() > 0) {
            throw new IllegalArgumentException("Run builder.cleanup() before writing the graph");
        }
        for (FeatureId featureId : featureStateSuppliers.keySet()) {
            if (this.featureMap.containsKey((Object)featureId)) continue;
            throw new IllegalArgumentException(String.format("Feature %s not configured for index", new Object[]{featureId}));
        }
        if (this.ordinalMapper.maxOrdinal() < this.graph.size(0) - 1) {
            String msg = String.format("Ordinal mapper from [0..%d] does not cover all nodes in the graph of size %d", this.ordinalMapper.maxOrdinal(), this.graph.size(0));
            throw new IllegalStateException(msg);
        }
        ImmutableGraphIndex.View view = this.graph.getView();
        this.writeHeader(view);
        this.writeL0Records(view, featureStateSuppliers);
        this.writeSparseLevels(view, featureStateSuppliers);
        this.writeSeparatedFeatures(featureStateSuppliers);
        if (this.version >= 5) {
            this.writeFooter(view, ((RandomAccessWriter)this.out).position());
        }
        long endOfGraphPosition = ((RandomAccessWriter)this.out).position();
        this.writeHeader(view);
        ((RandomAccessWriter)this.out).seek(endOfGraphPosition);
        ((RandomAccessWriter)this.out).flush();
        view.close();
    }

    protected abstract void writeL0Records(ImmutableGraphIndex.View var1, Map<FeatureId, IntFunction<Feature.State>> var2) throws IOException;

    protected long featureOffsetForOrdinal(int ordinal) {
        return super.featureOffsetForOrdinal(this.startOffset, ordinal);
    }

    public synchronized void writeHeader(ImmutableGraphIndex.View view) throws IOException {
        ((RandomAccessWriter)this.out).seek(this.startOffset);
        super.writeHeader(view, this.startOffset);
        ((RandomAccessWriter)this.out).flush();
    }

    public synchronized long checksum() throws IOException {
        long endOffset = ((RandomAccessWriter)this.out).position();
        return ((RandomAccessWriter)this.out).checksum(this.startOffset, endOffset);
    }
}

