/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.annotations.Experimental;
import io.github.jbellis.jvector.disk.BufferedRandomAccessWriter;
import io.github.jbellis.jvector.disk.RandomAccessWriter;
import io.github.jbellis.jvector.graph.ImmutableGraphIndex;
import io.github.jbellis.jvector.graph.disk.AbstractGraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.OrdinalMapper;
import io.github.jbellis.jvector.graph.disk.ParallelGraphWriter;
import io.github.jbellis.jvector.graph.disk.RandomAccessOnDiskGraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.IntFunction;

public class OnDiskParallelGraphIndexWriter
extends RandomAccessOnDiskGraphIndexWriter {
    private final Path filePath;
    private final int parallelWorkerThreads;
    private final boolean parallelUseDirectBuffers;

    OnDiskParallelGraphIndexWriter(RandomAccessWriter randomAccessWriter, int version, long startOffset, ImmutableGraphIndex graph, OrdinalMapper oldToNewOrdinals, int dimension, EnumMap<FeatureId, Feature> features, Path filePath, int parallelWorkerThreads, boolean parallelUseDirectBuffers) {
        super(randomAccessWriter, version, startOffset, graph, oldToNewOrdinals, dimension, features);
        if (filePath == null) {
            throw new IllegalStateException("Parallel writes require a file path");
        }
        this.filePath = filePath;
        this.parallelWorkerThreads = parallelWorkerThreads;
        this.parallelUseDirectBuffers = parallelUseDirectBuffers;
    }

    @Override
    @Experimental
    protected void writeL0Records(ImmutableGraphIndex.View view, Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers) throws IOException {
        ((RandomAccessWriter)this.out).flush();
        long baseOffset = ((RandomAccessWriter)this.out).position();
        ParallelGraphWriter.Config config = new ParallelGraphWriter.Config(this.parallelWorkerThreads, this.parallelUseDirectBuffers, 4);
        try (ParallelGraphWriter parallelWriter = new ParallelGraphWriter((RandomAccessWriter)this.out, this.graph, this.inlineFeatures, config, this.filePath);){
            parallelWriter.writeL0Records(this.ordinalMapper, this.inlineFeatures, featureStateSuppliers, baseOffset);
            this.maxOrdinalWritten = this.ordinalMapper.maxOrdinal();
            long endOffset = baseOffset + (long)(this.ordinalMapper.maxOrdinal() + 1) * (long)parallelWriter.getRecordSize();
            if (this.out instanceof BufferedRandomAccessWriter) {
                ((BufferedRandomAccessWriter)this.out).invalidateCache();
            }
            ((RandomAccessWriter)this.out).seek(endOffset);
        }
    }

    public static class Builder
    extends AbstractGraphIndexWriter.Builder<OnDiskParallelGraphIndexWriter, RandomAccessWriter> {
        private long startOffset = 0L;
        private final Path filePath;
        private int parallelWorkerThreads = 0;
        private boolean parallelUseDirectBuffers = false;

        public Builder(ImmutableGraphIndex graphIndex, Path outPath) throws FileNotFoundException {
            super(graphIndex, new BufferedRandomAccessWriter(outPath));
            this.filePath = outPath;
        }

        public Builder withStartOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        public Builder withParallelWorkerThreads(int workerThreads) {
            this.parallelWorkerThreads = workerThreads;
            return this;
        }

        public Builder withParallelDirectBuffers(boolean useDirectBuffers) {
            this.parallelUseDirectBuffers = useDirectBuffers;
            return this;
        }

        @Override
        protected OnDiskParallelGraphIndexWriter reallyBuild(int dimension) {
            return new OnDiskParallelGraphIndexWriter((RandomAccessWriter)this.out, this.version, this.startOffset, this.graphIndex, this.ordinalMapper, dimension, this.features, this.filePath, this.parallelWorkerThreads, this.parallelUseDirectBuffers);
        }
    }
}

