/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.util.Accountable;
import io.github.jbellis.jvector.util.Bits;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public interface ImmutableGraphIndex
extends AutoCloseable,
Accountable {
    @Deprecated
    default public int size() {
        return this.size(0);
    }

    public NodesIterator getNodes(int var1);

    public View getView();

    public int maxDegree();

    public List<Integer> maxDegrees();

    public int getDimension();

    default public int getIdUpperBound() {
        return this.size();
    }

    default public boolean containsNode(int nodeId) {
        return nodeId >= 0 && nodeId < this.size();
    }

    @Override
    public void close() throws IOException;

    public boolean isHierarchical();

    public int getMaxLevel();

    public int getDegree(int var1);

    public double getAverageDegree(int var1);

    public int size(int var1);

    public static String prettyPrint(ImmutableGraphIndex graph) {
        StringBuilder sb = new StringBuilder();
        sb.append(graph);
        sb.append("\n");
        try (View view = graph.getView();){
            for (int level = 0; level <= graph.getMaxLevel(); ++level) {
                sb.append(String.format("# Level %d\n", level));
                NodesIterator it = graph.getNodes(level);
                while (it.hasNext()) {
                    int node = it.nextInt();
                    sb.append("  ").append(node).append(" -> ");
                    NodesIterator neighbors = view.getNeighborsIterator(level, node);
                    while (neighbors.hasNext()) {
                        sb.append(" ").append(neighbors.nextInt());
                    }
                    sb.append("\n");
                }
                sb.append("\n");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static interface View
    extends Closeable {
        public NodesIterator getNeighborsIterator(int var1, int var2);

        public void processNeighbors(int var1, int var2, ScoreFunction var3, IntMarker var4, NeighborProcessor var5);

        @Deprecated
        public int size();

        public NodeAtLevel entryNode();

        public Bits liveNodes();

        default public int getIdUpperBound() {
            return this.size();
        }

        public boolean contains(int var1, int var2);
    }

    public static final class NodeAtLevel
    implements Comparable<NodeAtLevel> {
        public final int level;
        public final int node;

        public NodeAtLevel(int level, int node) {
            assert (level >= 0) : level;
            assert (node >= 0) : node;
            this.level = level;
            this.node = node;
        }

        @Override
        public int compareTo(NodeAtLevel o) {
            int cmp = Integer.compare(this.level, o.level);
            if (cmp == 0) {
                cmp = Integer.compare(this.node, o.node);
            }
            return cmp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NodeAtLevel)) {
                return false;
            }
            NodeAtLevel that = (NodeAtLevel)o;
            return this.level == that.level && this.node == that.node;
        }

        public int hashCode() {
            return Objects.hash(this.level, this.node);
        }

        public String toString() {
            return "NodeAtLevel(level=" + this.level + ", node=" + this.node + ")";
        }
    }

    public static interface ScoringView
    extends View {
        public ScoreFunction.ExactScoreFunction rerankerFor(VectorFloat<?> var1, VectorSimilarityFunction var2);

        public ScoreFunction.ApproximateScoreFunction approximateScoreFunctionFor(VectorFloat<?> var1, VectorSimilarityFunction var2);
    }

    @FunctionalInterface
    public static interface IntMarker {
        public boolean mark(int var1);
    }

    public static interface NeighborProcessor {
        public void process(int var1, float var2);
    }
}

