/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.util;

import io.github.jbellis.jvector.annotations.VisibleForTesting;
import io.github.jbellis.jvector.util.AbstractLongHeap;
import java.util.PrimitiveIterator;

public class BoundedLongHeap
extends AbstractLongHeap {
    private int maxSize;

    public BoundedLongHeap(int maxSize) {
        this(maxSize, maxSize);
    }

    public BoundedLongHeap(int initialSize, int maxSize) {
        super(initialSize);
        this.maxSize = maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (this.size > maxSize) {
            throw new IllegalArgumentException("Cannot set maxSize smaller than current size");
        }
        this.maxSize = maxSize;
    }

    @Override
    public boolean push(long value) {
        if (this.size >= this.maxSize) {
            if (value < this.heap[1]) {
                return false;
            }
            this.updateTop(value);
            return true;
        }
        this.add(value);
        return true;
    }

    @Override
    public void pushMany(PrimitiveIterator.OfLong elements, int elementsSize) {
        if (elementsSize + this.size > this.maxSize) {
            throw new IllegalArgumentException("Cannot add more elements than maxSize");
        }
        this.addMany(elements, elementsSize);
    }

    @VisibleForTesting
    long updateTop(long value) {
        this.heap[1] = value;
        this.downHeap(1);
        return this.heap[1];
    }
}

