/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.annotations.Experimental;
import io.github.jbellis.jvector.disk.BufferedRandomAccessWriter;
import io.github.jbellis.jvector.disk.RandomAccessWriter;
import io.github.jbellis.jvector.graph.ImmutableGraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.OnHeapGraphIndex;
import io.github.jbellis.jvector.graph.disk.AbstractGraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.OrdinalMapper;
import io.github.jbellis.jvector.graph.disk.ParallelGraphWriter;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.IntFunction;

public class OnDiskGraphIndexWriter
extends AbstractGraphIndexWriter<RandomAccessWriter> {
    private final long startOffset;
    private volatile boolean useParallelWrites = false;
    private final Path filePath;
    private final int parallelWorkerThreads;
    private final boolean parallelUseDirectBuffers;

    OnDiskGraphIndexWriter(RandomAccessWriter randomAccessWriter, int version, long startOffset, ImmutableGraphIndex graph, OrdinalMapper oldToNewOrdinals, int dimension, EnumMap<FeatureId, Feature> features, Path filePath, int parallelWorkerThreads, boolean parallelUseDirectBuffers) {
        super(randomAccessWriter, version, graph, oldToNewOrdinals, dimension, features);
        this.startOffset = startOffset;
        this.filePath = filePath;
        this.parallelWorkerThreads = parallelWorkerThreads;
        this.parallelUseDirectBuffers = parallelUseDirectBuffers;
    }

    OnDiskGraphIndexWriter(RandomAccessWriter randomAccessWriter, int version, long startOffset, ImmutableGraphIndex graph, OrdinalMapper oldToNewOrdinals, int dimension, EnumMap<FeatureId, Feature> features) {
        this(randomAccessWriter, version, startOffset, graph, oldToNewOrdinals, dimension, features, null, 0, false);
    }

    @Override
    public synchronized void close() throws IOException {
        ((RandomAccessWriter)this.out).close();
    }

    public RandomAccessWriter getOutput() {
        return (RandomAccessWriter)this.out;
    }

    public synchronized void writeInline(int ordinal, Map<FeatureId, Feature.State> stateMap) throws IOException {
        for (FeatureId featureId : stateMap.keySet()) {
            if (this.featureMap.containsKey((Object)featureId)) continue;
            throw new IllegalArgumentException(String.format("Feature %s not configured for index", new Object[]{featureId}));
        }
        ((RandomAccessWriter)this.out).seek(this.featureOffsetForOrdinal(ordinal));
        for (Feature feature : this.inlineFeatures) {
            Feature.State state = stateMap.get((Object)feature.id());
            if (state == null) {
                ((RandomAccessWriter)this.out).seek(((RandomAccessWriter)this.out).position() + (long)feature.featureSize());
                continue;
            }
            feature.writeInline(this.out, state);
        }
        this.maxOrdinalWritten = Math.max(this.maxOrdinalWritten, ordinal);
    }

    private long featureOffsetForOrdinal(int ordinal) {
        return super.featureOffsetForOrdinal(this.startOffset, ordinal);
    }

    @Override
    public synchronized void write(Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers) throws IOException {
        Object ohgi;
        if (this.graph instanceof OnHeapGraphIndex && ((OnHeapGraphIndex)(ohgi = (OnHeapGraphIndex)this.graph)).getDeletedNodes().cardinality() > 0) {
            throw new IllegalArgumentException("Run builder.cleanup() before writing the graph");
        }
        for (FeatureId featureId : featureStateSuppliers.keySet()) {
            if (this.featureMap.containsKey((Object)featureId)) continue;
            throw new IllegalArgumentException(String.format("Feature %s not configured for index", new Object[]{featureId}));
        }
        if (this.ordinalMapper.maxOrdinal() < this.graph.size(0) - 1) {
            String msg = String.format("Ordinal mapper from [0..%d] does not cover all nodes in the graph of size %d", this.ordinalMapper.maxOrdinal(), this.graph.size(0));
            throw new IllegalStateException(msg);
        }
        ImmutableGraphIndex.View view = this.graph.getView();
        this.writeHeader(view);
        if (this.useParallelWrites) {
            this.writeL0RecordsParallel(featureStateSuppliers);
        } else {
            this.writeL0RecordsSequential(view, featureStateSuppliers);
        }
        this.writeSparseLevels(view, featureStateSuppliers);
        this.writeSeparatedFeatures(featureStateSuppliers);
        if (this.version >= 5) {
            this.writeFooter(view, ((RandomAccessWriter)this.out).position());
        }
        long endOfGraphPosition = ((RandomAccessWriter)this.out).position();
        this.writeHeader(view);
        ((RandomAccessWriter)this.out).seek(endOfGraphPosition);
        ((RandomAccessWriter)this.out).flush();
        view.close();
    }

    @Experimental
    private void writeL0RecordsParallel(Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers) throws IOException {
        if (this.filePath == null) {
            throw new IllegalStateException("Parallel writes require a file path. Use Builder(ImmutableGraphIndex, Path) constructor.");
        }
        ((RandomAccessWriter)this.out).flush();
        long baseOffset = ((RandomAccessWriter)this.out).position();
        ParallelGraphWriter.Config config = new ParallelGraphWriter.Config(this.parallelWorkerThreads, this.parallelUseDirectBuffers, 4);
        try (ParallelGraphWriter parallelWriter = new ParallelGraphWriter((RandomAccessWriter)this.out, this.graph, this.inlineFeatures, config, this.filePath);){
            parallelWriter.writeL0Records(this.ordinalMapper, this.inlineFeatures, featureStateSuppliers, baseOffset);
            this.maxOrdinalWritten = this.ordinalMapper.maxOrdinal();
            long endOffset = baseOffset + (long)(this.ordinalMapper.maxOrdinal() + 1) * (long)parallelWriter.getRecordSize();
            ((RandomAccessWriter)this.out).seek(endOffset);
        }
    }

    private void writeL0RecordsSequential(ImmutableGraphIndex.View view, Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers) throws IOException {
        for (int newOrdinal = 0; newOrdinal <= this.ordinalMapper.maxOrdinal(); ++newOrdinal) {
            int n;
            int originalOrdinal = this.ordinalMapper.newToOld(newOrdinal);
            if (originalOrdinal == Integer.MIN_VALUE) {
                ((RandomAccessWriter)this.out).writeInt(-1);
                for (Feature feature : this.inlineFeatures) {
                    ((RandomAccessWriter)this.out).seek(((RandomAccessWriter)this.out).position() + (long)feature.featureSize());
                }
                ((RandomAccessWriter)this.out).writeInt(0);
                for (int n2 = 0; n2 < this.graph.getDegree(0); ++n2) {
                    ((RandomAccessWriter)this.out).writeInt(-1);
                }
                continue;
            }
            if (!this.graph.containsNode(originalOrdinal)) {
                String msg = String.format("Ordinal mapper mapped new ordinal %s to non-existing node %s", newOrdinal, originalOrdinal);
                throw new IllegalStateException(msg);
            }
            ((RandomAccessWriter)this.out).writeInt(newOrdinal);
            assert (((RandomAccessWriter)this.out).position() == this.featureOffsetForOrdinal(newOrdinal)) : String.format("%d != %d", ((RandomAccessWriter)this.out).position(), this.featureOffsetForOrdinal(newOrdinal));
            for (Feature feature : this.inlineFeatures) {
                IntFunction<Feature.State> supplier = featureStateSuppliers.get((Object)feature.id());
                if (supplier == null) {
                    ((RandomAccessWriter)this.out).seek(((RandomAccessWriter)this.out).position() + (long)feature.featureSize());
                    continue;
                }
                feature.writeInline(this.out, supplier.apply(originalOrdinal));
            }
            NodesIterator neighbors = view.getNeighborsIterator(0, originalOrdinal);
            if (neighbors.size() > this.graph.getDegree(0)) {
                String msg = String.format("Node %d has more neighbors %d than the graph's max degree %d -- run Builder.cleanup()!", originalOrdinal, neighbors.size(), this.graph.getDegree(0));
                throw new IllegalStateException(msg);
            }
            ((RandomAccessWriter)this.out).writeInt(neighbors.size());
            for (n = 0; n < neighbors.size(); ++n) {
                int newNeighborOrdinal = this.ordinalMapper.oldToNew(neighbors.nextInt());
                if (newNeighborOrdinal < 0 || newNeighborOrdinal > this.ordinalMapper.maxOrdinal()) {
                    String msg = String.format("Neighbor ordinal out of bounds: %d/%d", newNeighborOrdinal, this.ordinalMapper.maxOrdinal());
                    throw new IllegalStateException(msg);
                }
                ((RandomAccessWriter)this.out).writeInt(newNeighborOrdinal);
            }
            assert (!neighbors.hasNext());
            while (n < this.graph.getDegree(0)) {
                ((RandomAccessWriter)this.out).writeInt(-1);
                ++n;
            }
        }
    }

    public synchronized void writeHeader(ImmutableGraphIndex.View view) throws IOException {
        ((RandomAccessWriter)this.out).seek(this.startOffset);
        super.writeHeader(view, this.startOffset);
        ((RandomAccessWriter)this.out).flush();
    }

    public synchronized long checksum() throws IOException {
        long endOffset = ((RandomAccessWriter)this.out).position();
        return ((RandomAccessWriter)this.out).checksum(this.startOffset, endOffset);
    }

    public void setParallelWrites(boolean enabled) {
        this.useParallelWrites = enabled;
    }

    public static class Builder
    extends AbstractGraphIndexWriter.Builder<OnDiskGraphIndexWriter, RandomAccessWriter> {
        private long startOffset = 0L;
        private boolean useParallelWrites = false;
        private Path filePath = null;
        private int parallelWorkerThreads = 0;
        private boolean parallelUseDirectBuffers = false;

        public Builder(ImmutableGraphIndex graphIndex, Path outPath) throws FileNotFoundException {
            this(graphIndex, new BufferedRandomAccessWriter(outPath));
            this.filePath = outPath;
        }

        public Builder(ImmutableGraphIndex graphIndex, RandomAccessWriter out) {
            super(graphIndex, out);
        }

        public Builder withStartOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        public Builder withParallelWrites(boolean enabled) {
            this.useParallelWrites = enabled;
            return this;
        }

        public Builder withParallelWorkerThreads(int workerThreads) {
            this.parallelWorkerThreads = workerThreads;
            return this;
        }

        public Builder withParallelDirectBuffers(boolean useDirectBuffers) {
            this.parallelUseDirectBuffers = useDirectBuffers;
            return this;
        }

        @Override
        protected OnDiskGraphIndexWriter reallyBuild(int dimension) {
            OnDiskGraphIndexWriter writer = new OnDiskGraphIndexWriter((RandomAccessWriter)this.out, this.version, this.startOffset, this.graphIndex, this.ordinalMapper, dimension, this.features, this.filePath, this.parallelWorkerThreads, this.parallelUseDirectBuffers);
            writer.setParallelWrites(this.useParallelWrites);
            return writer;
        }
    }
}

