/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.ByteBufferIndexWriter;
import io.github.jbellis.jvector.graph.ImmutableGraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.disk.OrdinalMapper;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.IntFunction;

class NodeRecordTask
implements Callable<List<Result>> {
    private final int startOrdinal;
    private final int endOrdinal;
    private final OrdinalMapper ordinalMapper;
    private final ImmutableGraphIndex graph;
    private final ImmutableGraphIndex.View view;
    private final List<Feature> inlineFeatures;
    private final Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers;
    private final int recordSize;
    private final long baseOffset;
    private final ByteBuffer buffer;

    NodeRecordTask(int startOrdinal, int endOrdinal, OrdinalMapper ordinalMapper, ImmutableGraphIndex graph, ImmutableGraphIndex.View view, List<Feature> inlineFeatures, Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers, int recordSize, long baseOffset, ByteBuffer buffer) {
        this.startOrdinal = startOrdinal;
        this.endOrdinal = endOrdinal;
        this.ordinalMapper = ordinalMapper;
        this.graph = graph;
        this.view = view;
        this.inlineFeatures = inlineFeatures;
        this.featureStateSuppliers = featureStateSuppliers;
        this.recordSize = recordSize;
        this.baseOffset = baseOffset;
        this.buffer = buffer;
    }

    @Override
    public List<Result> call() throws Exception {
        ArrayList<Result> results = new ArrayList<Result>(this.endOrdinal - this.startOrdinal);
        ByteBufferIndexWriter writer = new ByteBufferIndexWriter(this.buffer);
        for (int newOrdinal = this.startOrdinal; newOrdinal < this.endOrdinal; ++newOrdinal) {
            long fileOffset = this.baseOffset + (long)newOrdinal * (long)this.recordSize;
            writer.reset();
            int originalOrdinal = this.ordinalMapper.newToOld(newOrdinal);
            writer.writeInt(newOrdinal);
            if (originalOrdinal == Integer.MIN_VALUE) {
                for (Feature feature : this.inlineFeatures) {
                    for (int i = 0; i < feature.featureSize(); ++i) {
                        writer.writeByte(0);
                    }
                }
                writer.writeInt(0);
                for (int n = 0; n < this.graph.getDegree(0); ++n) {
                    writer.writeInt(-1);
                }
            } else {
                int n;
                if (!this.graph.containsNode(originalOrdinal)) {
                    throw new IllegalStateException(String.format("Ordinal mapper mapped new ordinal %s to non-existing node %s", newOrdinal, originalOrdinal));
                }
                for (Feature feature : this.inlineFeatures) {
                    IntFunction<Feature.State> supplier = this.featureStateSuppliers.get((Object)feature.id());
                    if (supplier == null) {
                        for (int i = 0; i < feature.featureSize(); ++i) {
                            writer.writeByte(0);
                        }
                        continue;
                    }
                    feature.writeInline(writer, supplier.apply(originalOrdinal));
                }
                NodesIterator neighbors = this.view.getNeighborsIterator(0, originalOrdinal);
                if (neighbors.size() > this.graph.getDegree(0)) {
                    throw new IllegalStateException(String.format("Node %d has more neighbors %d than the graph's max degree %d -- run Builder.cleanup()!", originalOrdinal, neighbors.size(), this.graph.getDegree(0)));
                }
                writer.writeInt(neighbors.size());
                for (n = 0; n < neighbors.size(); ++n) {
                    int newNeighborOrdinal = this.ordinalMapper.oldToNew(neighbors.nextInt());
                    if (newNeighborOrdinal < 0 || newNeighborOrdinal > this.ordinalMapper.maxOrdinal()) {
                        throw new IllegalStateException(String.format("Neighbor ordinal out of bounds: %d/%d", newNeighborOrdinal, this.ordinalMapper.maxOrdinal()));
                    }
                    writer.writeInt(newNeighborOrdinal);
                }
                while (n < this.graph.getDegree(0)) {
                    writer.writeInt(-1);
                    ++n;
                }
            }
            if (writer.bytesWritten() != this.recordSize) {
                throw new IllegalStateException(String.format("Record size mismatch for ordinal %d: expected %d bytes, wrote %d bytes", newOrdinal, this.recordSize, writer.bytesWritten()));
            }
            ByteBuffer dataCopy = writer.cloneBuffer();
            results.add(new Result(newOrdinal, fileOffset, dataCopy));
        }
        return results;
    }

    static class Result {
        final int newOrdinal;
        final long fileOffset;
        final ByteBuffer data;

        Result(int newOrdinal, long fileOffset, ByteBuffer data) {
            this.newOrdinal = newOrdinal;
            this.fileOffset = fileOffset;
            this.data = data;
        }
    }
}

