/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.IndexWriter;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;

class Header {
    final CommonHeader common;
    final Map<FeatureId, ? extends Feature> features;

    Header(CommonHeader common, Map<FeatureId, ? extends Feature> features) {
        this.common = common;
        this.features = features;
    }

    void write(IndexWriter out) throws IOException {
        this.common.write(out);
        if (this.common.version >= 6) {
            out.writeInt(this.features.size());
            for (FeatureId featureId : this.features.keySet()) {
                out.writeInt(featureId.ordinal());
                Feature feature = this.features.get((Object)featureId);
                feature.writeHeader(out);
            }
        } else {
            if (this.common.version >= 3) {
                out.writeInt(FeatureId.serialize(EnumSet.copyOf(this.features.keySet())));
            }
            for (Feature feature : this.features.values()) {
                feature.writeHeader(out);
            }
        }
    }

    public int size() {
        int size = this.common.size();
        if (this.common.version >= 6) {
            size += 4 + this.features.size() * 4;
        } else if (this.common.version >= 3) {
            size += 4;
        }
        return size += this.features.values().stream().mapToInt(Feature::headerSize).sum();
    }

    static Header load(RandomAccessReader reader, long offset) throws IOException {
        AbstractMap features;
        reader.seek(offset);
        CommonHeader common = CommonHeader.load(reader);
        if (common.version >= 6) {
            features = new LinkedHashMap();
            int nFeatures = reader.readInt();
            for (int i = 0; i < nFeatures; ++i) {
                FeatureId featureId = FeatureId.values()[reader.readInt()];
                features.put(featureId, featureId.load(common, reader));
            }
        } else {
            features = new EnumMap(FeatureId.class);
            EnumSet<FeatureId> featureIds = common.version >= 3 ? FeatureId.deserialize(reader.readInt()) : EnumSet.of(FeatureId.INLINE_VECTORS);
            for (FeatureId featureId : featureIds) {
                features.put(featureId, featureId.load(common, reader));
            }
        }
        return new Header(common, features);
    }
}

