/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public interface NodesIterator
extends PrimitiveIterator.OfInt {
    public static final EmptyNodeIterator EMPTY_NODE_ITERATOR = new EmptyNodeIterator();

    public int size();

    public static NodesIterator fromPrimitiveIterator(final PrimitiveIterator.OfInt iterator, final int size) {
        return new NodesIterator(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public int nextInt() {
                return iterator.nextInt();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }
        };
    }

    public static class EmptyNodeIterator
    implements NodesIterator {
        @Override
        public int size() {
            return 0;
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    }

    public static class ArrayNodesIterator
    implements NodesIterator {
        private final int[] nodes;
        private int cur = 0;
        private final int size;

        public ArrayNodesIterator(int[] nodes, int size) {
            assert (nodes != null);
            assert (size <= nodes.length);
            this.size = size;
            this.nodes = nodes;
        }

        @Override
        public int size() {
            return this.size;
        }

        public ArrayNodesIterator(int[] nodes) {
            this(nodes, nodes.length);
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nodes == null) {
                return this.cur++;
            }
            return this.nodes[this.cur++];
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.size;
        }
    }
}

