/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector;

import io.github.jbellis.jvector.vector.VectorUtil;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;

public class Matrix {
    private static final VectorTypeSupport vts = VectorizationProvider.getInstance().getVectorTypeSupport();
    VectorFloat<?>[] data;

    public Matrix(int m, int n) {
        this(m, n, true);
    }

    public Matrix(int m, int n, boolean allocateZeroed) {
        this.data = new VectorFloat[m];
        if (allocateZeroed) {
            for (int i = 0; i < m; ++i) {
                this.data[i] = vts.createFloatVector(n);
            }
        }
    }

    public float get(int i, int j) {
        return this.data[i].get(j);
    }

    public void set(int i, int j, float value) {
        this.data[i].set(j, value);
    }

    public boolean isIsomorphicWith(Matrix other) {
        return this.data.length == other.data.length && this.data[0].length() == other.data[0].length();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (VectorFloat<?> row : this.data) {
            sb.append(row.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public Matrix invert() {
        int i;
        if (this.data.length == 0 || this.data.length != this.data[0].length()) {
            throw new IllegalArgumentException("matrix must be square");
        }
        int N = this.data.length;
        Matrix augmented = new Matrix(N, 2 * N);
        for (i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                augmented.set(i, j, this.get(i, j));
                augmented.set(i, j + N, i == j ? 1.0f : 0.0f);
            }
        }
        for (i = 0; i < N; ++i) {
            int maxRow = i;
            for (int k = i + 1; k < N; ++k) {
                if (!(Math.abs(augmented.get(k, i)) > Math.abs(augmented.get(maxRow, i)))) continue;
                maxRow = k;
            }
            VectorFloat<?> temp = augmented.data[i];
            augmented.data[i] = augmented.data[maxRow];
            augmented.data[maxRow] = temp;
            VectorUtil.scale(augmented.data[i], 1.0f / augmented.get(i, i));
            for (int k = 0; k < N; ++k) {
                if (k == i) continue;
                float factor = augmented.get(k, i);
                for (int j = 0; j < 2 * N; ++j) {
                    augmented.addTo(k, j, -factor * augmented.get(i, j));
                }
            }
        }
        Matrix inverse = new Matrix(N, N);
        for (int i2 = 0; i2 < N; ++i2) {
            inverse.data[i2].copyFrom(augmented.data[i2], N, 0, N);
        }
        return inverse;
    }

    public void addTo(int i, int j, float delta) {
        this.data[i].set(j, this.data[i].get(j) + delta);
    }

    public void addInPlace(Matrix other) {
        if (!this.isIsomorphicWith(other)) {
            throw new IllegalArgumentException("matrix dimensions differ for " + String.valueOf(this) + "!=" + String.valueOf(other));
        }
        for (int i = 0; i < this.data.length; ++i) {
            VectorUtil.addInPlace(this.data[i], other.data[i]);
        }
    }

    public VectorFloat<?> multiply(VectorFloat<?> v) {
        if (this.data.length == 0) {
            throw new IllegalArgumentException("Cannot multiply empty matrix");
        }
        if (v.length() == 0) {
            throw new IllegalArgumentException("Cannot multiply empty vector");
        }
        VectorFloat<?> result = vts.createFloatVector(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            result.set(i, VectorUtil.dotProduct(this.data[i], v));
        }
        return result;
    }

    public static Matrix outerProduct(VectorFloat<?> a, VectorFloat<?> b) {
        Matrix result = new Matrix(a.length(), b.length(), false);
        for (int i = 0; i < a.length(); ++i) {
            VectorFloat<?> rowI = b.copy();
            VectorUtil.scale(rowI, a.get(i));
            result.data[i] = rowI;
        }
        return result;
    }

    public void scale(float multiplier) {
        for (VectorFloat<?> row : this.data) {
            VectorUtil.scale(row, multiplier);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix)) {
            return false;
        }
        Matrix other = (Matrix)obj;
        if (this.data.length != other.data.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].equals(other.data[i])) continue;
            return false;
        }
        return true;
    }

    public static Matrix from(float[][] values) {
        Matrix result = new Matrix(values.length, values[0].length, false);
        for (int i = 0; i < values.length; ++i) {
            result.data[i] = vts.createFloatVector(values[i]);
        }
        return result;
    }
}

