/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.annotations.Experimental;
import io.github.jbellis.jvector.annotations.VisibleForTesting;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.GraphSearcher;
import io.github.jbellis.jvector.graph.ImmutableGraphIndex;
import io.github.jbellis.jvector.graph.MutableGraphIndex;
import io.github.jbellis.jvector.graph.NodeArray;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.OnHeapGraphIndex;
import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.SearchResult;
import io.github.jbellis.jvector.graph.diversity.VamanaDiversityProvider;
import io.github.jbellis.jvector.graph.similarity.BuildScoreProvider;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.graph.similarity.SearchScoreProvider;
import io.github.jbellis.jvector.util.Bits;
import io.github.jbellis.jvector.util.ExceptionUtils;
import io.github.jbellis.jvector.util.ExplicitThreadLocal;
import io.github.jbellis.jvector.util.PhysicalCoreExecutor;
import io.github.jbellis.jvector.util.ThreadSafeGrowableBitSet;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphIndexBuilder
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(GraphIndexBuilder.class);
    private final int beamWidth;
    private final ExplicitThreadLocal<NodeArray> naturalScratch;
    private final ExplicitThreadLocal<NodeArray> concurrentScratch;
    private final int dimension;
    private final float neighborOverflow;
    private final float alpha;
    private final boolean addHierarchy;
    private final boolean refineFinalGraph;
    @VisibleForTesting
    final MutableGraphIndex graph;
    private final ConcurrentSkipListSet<ImmutableGraphIndex.NodeAtLevel> insertionsInProgress = new ConcurrentSkipListSet();
    private final BuildScoreProvider scoreProvider;
    private final ForkJoinPool simdExecutor;
    private final ForkJoinPool parallelExecutor;
    private final ExplicitThreadLocal<GraphSearcher> searchers;
    private final Random rng;

    public GraphIndexBuilder(RandomAccessVectorValues vectorValues, VectorSimilarityFunction similarityFunction, int M, int beamWidth, float neighborOverflow, float alpha, boolean addHierarchy) {
        this(BuildScoreProvider.randomAccessScoreProvider(vectorValues, similarityFunction), vectorValues.dimension(), M, beamWidth, neighborOverflow, alpha, addHierarchy, true);
    }

    public GraphIndexBuilder(RandomAccessVectorValues vectorValues, VectorSimilarityFunction similarityFunction, int M, int beamWidth, float neighborOverflow, float alpha, boolean addHierarchy, boolean refineFinalGraph) {
        this(BuildScoreProvider.randomAccessScoreProvider(vectorValues, similarityFunction), vectorValues.dimension(), M, beamWidth, neighborOverflow, alpha, addHierarchy, refineFinalGraph);
    }

    public GraphIndexBuilder(BuildScoreProvider scoreProvider, int dimension, int M, int beamWidth, float neighborOverflow, float alpha, boolean addHierarchy) {
        this(scoreProvider, dimension, M, beamWidth, neighborOverflow, alpha, addHierarchy, true, PhysicalCoreExecutor.pool(), ForkJoinPool.commonPool());
    }

    public GraphIndexBuilder(BuildScoreProvider scoreProvider, int dimension, int M, int beamWidth, float neighborOverflow, float alpha, boolean addHierarchy, boolean refineFinalGraph) {
        this(scoreProvider, dimension, M, beamWidth, neighborOverflow, alpha, addHierarchy, refineFinalGraph, PhysicalCoreExecutor.pool(), ForkJoinPool.commonPool());
    }

    public GraphIndexBuilder(BuildScoreProvider scoreProvider, int dimension, int M, int beamWidth, float neighborOverflow, float alpha, boolean addHierarchy, boolean refineFinalGraph, ForkJoinPool simdExecutor, ForkJoinPool parallelExecutor) {
        this(scoreProvider, dimension, List.of(Integer.valueOf(M)), beamWidth, neighborOverflow, alpha, addHierarchy, refineFinalGraph, simdExecutor, parallelExecutor);
    }

    public GraphIndexBuilder(BuildScoreProvider scoreProvider, int dimension, List<Integer> maxDegrees, int beamWidth, float neighborOverflow, float alpha, boolean addHierarchy, boolean refineFinalGraph) {
        this(scoreProvider, dimension, maxDegrees, beamWidth, neighborOverflow, alpha, addHierarchy, refineFinalGraph, PhysicalCoreExecutor.pool(), ForkJoinPool.commonPool());
    }

    public GraphIndexBuilder(BuildScoreProvider scoreProvider, int dimension, List<Integer> maxDegrees, int beamWidth, float neighborOverflow, float alpha, boolean addHierarchy, boolean refineFinalGraph, ForkJoinPool simdExecutor, ForkJoinPool parallelExecutor) {
        if (maxDegrees.stream().anyMatch(i -> i <= 0)) {
            throw new IllegalArgumentException("layer degrees must be positive");
        }
        if (maxDegrees.size() > 1 && !addHierarchy) {
            throw new IllegalArgumentException("Cannot specify multiple max degrees with addHierarchy=False");
        }
        if (beamWidth <= 0) {
            throw new IllegalArgumentException("beamWidth must be positive");
        }
        if (neighborOverflow < 1.0f) {
            throw new IllegalArgumentException("neighborOverflow must be >= 1.0");
        }
        if (alpha <= 0.0f) {
            throw new IllegalArgumentException("alpha must be positive");
        }
        this.scoreProvider = scoreProvider;
        this.dimension = dimension;
        this.neighborOverflow = neighborOverflow;
        this.alpha = alpha;
        this.addHierarchy = addHierarchy;
        this.refineFinalGraph = refineFinalGraph;
        this.beamWidth = beamWidth;
        this.simdExecutor = simdExecutor;
        this.parallelExecutor = parallelExecutor;
        this.graph = new OnHeapGraphIndex(maxDegrees, neighborOverflow, new VamanaDiversityProvider(scoreProvider, alpha));
        this.searchers = ExplicitThreadLocal.withInitial(() -> {
            GraphSearcher gs = new GraphSearcher(this.graph);
            gs.usePruning(false);
            return gs;
        });
        this.naturalScratch = ExplicitThreadLocal.withInitial(() -> new NodeArray(Math.max(beamWidth, this.graph.maxDegree() + 1)));
        this.concurrentScratch = ExplicitThreadLocal.withInitial(() -> new NodeArray(Math.max(beamWidth, this.graph.maxDegree() + 1)));
        this.rng = new Random(0L);
    }

    private GraphIndexBuilder(BuildScoreProvider buildScoreProvider, int dimension, MutableGraphIndex mutableGraphIndex, int beamWidth, float neighborOverflow, float alpha, boolean addHierarchy, boolean refineFinalGraph, ForkJoinPool simdExecutor, ForkJoinPool parallelExecutor) {
        if (beamWidth <= 0) {
            throw new IllegalArgumentException("beamWidth must be positive");
        }
        if (neighborOverflow < 1.0f) {
            throw new IllegalArgumentException("neighborOverflow must be >= 1.0");
        }
        if (alpha <= 0.0f) {
            throw new IllegalArgumentException("alpha must be positive");
        }
        this.scoreProvider = buildScoreProvider;
        this.neighborOverflow = neighborOverflow;
        this.dimension = dimension;
        this.alpha = alpha;
        this.addHierarchy = addHierarchy;
        this.refineFinalGraph = refineFinalGraph;
        this.beamWidth = beamWidth;
        this.simdExecutor = simdExecutor;
        this.parallelExecutor = parallelExecutor;
        this.graph = mutableGraphIndex;
        this.searchers = ExplicitThreadLocal.withInitial(() -> {
            GraphSearcher gs = new GraphSearcher(this.graph);
            gs.usePruning(false);
            return gs;
        });
        this.naturalScratch = ExplicitThreadLocal.withInitial(() -> new NodeArray(Math.max(beamWidth, this.graph.maxDegree() + 1)));
        this.concurrentScratch = ExplicitThreadLocal.withInitial(() -> new NodeArray(Math.max(beamWidth, this.graph.maxDegree() + 1)));
        this.rng = new Random(0L);
    }

    public static GraphIndexBuilder rescore(GraphIndexBuilder other, BuildScoreProvider newProvider) {
        GraphIndexBuilder newBuilder = new GraphIndexBuilder(newProvider, other.dimension, other.graph.maxDegrees(), other.beamWidth, other.neighborOverflow, other.alpha, other.addHierarchy, other.refineFinalGraph, other.simdExecutor, other.parallelExecutor);
        ImmutableGraphIndex.View otherView = other.graph.getView();
        ((ForkJoinTask)other.parallelExecutor.submit(() -> IntStream.range(0, other.graph.getIdUpperBound()).parallel().forEach(i -> {
            int maxLayer = other.graph.getMaxLevelForNode(i);
            if (maxLayer < 0) {
                return;
            }
            ScoreFunction sf = newProvider.searchProviderFor(i).scoreFunction();
            for (int lvl = 0; lvl <= maxLayer; ++lvl) {
                NodesIterator oldNeighborsIt = otherView.getNeighborsIterator(lvl, i);
                NodeArray newNeighbors = new NodeArray(oldNeighborsIt.size());
                while (oldNeighborsIt.hasNext()) {
                    int neighbor = oldNeighborsIt.nextInt();
                    newNeighbors.insertSorted(neighbor, sf.similarityTo(neighbor));
                }
                newBuilder.graph.connectNode(lvl, i, newNeighbors);
            }
        }))).join();
        newBuilder.graph.updateEntryNode(otherView.entryNode());
        return newBuilder;
    }

    public ImmutableGraphIndex build(RandomAccessVectorValues ravv) {
        Supplier<RandomAccessVectorValues> vv = ravv.threadLocalSupplier();
        int size = ravv.size();
        ((ForkJoinTask)this.simdExecutor.submit(() -> IntStream.range(0, size).parallel().forEach(arg_0 -> this.lambda$build$1((Supplier)vv, arg_0)))).join();
        this.cleanup();
        return this.graph;
    }

    void validateEntryNode() {
        if (this.graph.size(0) == 0) {
            return;
        }
        ImmutableGraphIndex.NodeAtLevel entry = this.graph.entryNode();
        if (entry == null || !this.graph.getView().contains(entry.level, entry.node)) {
            throw new IllegalStateException("Entry node was incompletely added! " + String.valueOf(entry));
        }
    }

    public void cleanup() {
        if (this.graph.size(0) == 0) {
            return;
        }
        this.validateEntryNode();
        this.removeDeletedNodes();
        if (this.graph.size(0) == 0) {
            return;
        }
        if (this.refineFinalGraph && this.graph.getMaxLevel() > 0) {
            ((ForkJoinTask)this.parallelExecutor.submit(() -> this.graph.nodeStream(1).parallel().forEach(this::improveConnections))).join();
        }
        ((ForkJoinTask)this.parallelExecutor.submit(() -> IntStream.range(0, this.graph.getIdUpperBound()).parallel().forEach(id -> {
            for (int level = 0; level <= this.graph.getMaxLevel(); ++level) {
                this.graph.enforceDegree(id);
            }
        }))).join();
        this.graph.setAllMutationsCompleted();
    }

    private void improveConnections(int node) {
        SearchScoreProvider ssp = this.scoreProvider.searchProviderFor(node);
        ExcludingBits bits = new ExcludingBits(node);
        try (GraphSearcher gs = this.searchers.get();){
            gs.initializeInternal(ssp, this.graph.entryNode(), bits);
            Bits acceptedBits = Bits.intersectionOf(bits, gs.getView().liveNodes());
            for (int lvl = this.graph.entryNode().level; lvl >= 0; --lvl) {
                ssp = this.scoreProvider.searchProviderFor(node);
                if (this.graph.getNeighborsIterator(lvl, node).size() > 0) {
                    gs.searchOneLayer(ssp, this.beamWidth, 0.0f, lvl, acceptedBits);
                    NodeArray candidates = new NodeArray(gs.approximateResults.size());
                    gs.approximateResults.foreach(candidates::insertSorted);
                    this.graph.addEdges(lvl, node, candidates, this.neighborOverflow);
                } else {
                    gs.searchOneLayer(ssp, 1, 0.0f, lvl, acceptedBits);
                }
                gs.setEntryPointsFromPreviousLayer();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ImmutableGraphIndex getGraph() {
        return this.graph;
    }

    public int insertsInProgress() {
        return this.insertionsInProgress.size();
    }

    @Deprecated
    public long addGraphNode(int node, RandomAccessVectorValues ravv) {
        return this.addGraphNode(node, ravv.getVector(node));
    }

    private int getRandomGraphLevel() {
        double randDouble;
        double ml;
        if (this.addHierarchy) {
            double d = ml = this.graph.getDegree(0) == 1 ? 1.0 : 1.0 / Math.log(1.0 * (double)this.graph.getDegree(0));
            while ((randDouble = this.rng.nextDouble()) == 0.0) {
            }
        } else {
            ml = 0.0;
            randDouble = 0.0;
        }
        return (int)(-Math.log(randDouble) * ml);
    }

    public long addGraphNode(int node, VectorFloat<?> vector) {
        SearchScoreProvider ssp = this.scoreProvider.searchProviderFor(vector);
        return this.addGraphNode(node, ssp);
    }

    public long addGraphNode(int node, SearchScoreProvider searchScoreProvider) {
        ImmutableGraphIndex.NodeAtLevel nodeLevel = new ImmutableGraphIndex.NodeAtLevel(this.getRandomGraphLevel(), node);
        this.graph.addNode(nodeLevel);
        this.insertionsInProgress.add(nodeLevel);
        Object inProgressBefore = this.insertionsInProgress.clone();
        try (GraphSearcher gs = this.searchers.get();){
            SearchResult result;
            ImmutableGraphIndex.View view = this.graph.getView();
            gs.setView(view);
            NodeArray naturalScratchPooled = this.naturalScratch.get();
            NodeArray concurrentScratchPooled = this.concurrentScratch.get();
            ExcludingBits bits = new ExcludingBits(nodeLevel.node);
            ImmutableGraphIndex.NodeAtLevel entry = view.entryNode();
            if (entry == null) {
                result = new SearchResult(new SearchResult.NodeScore[0], 0, 0, 0, 0, 0.0f);
            } else {
                gs.initializeInternal(searchScoreProvider, entry, bits);
                for (int lvl = entry.level; lvl > 0; --lvl) {
                    if (lvl > nodeLevel.level) {
                        gs.searchOneLayer(searchScoreProvider, 1, 0.0f, lvl, gs.getView().liveNodes());
                    } else {
                        gs.searchOneLayer(searchScoreProvider, this.beamWidth, 0.0f, lvl, gs.getView().liveNodes());
                        Object[] neighbors = new SearchResult.NodeScore[gs.approximateResults.size()];
                        AtomicInteger index = new AtomicInteger();
                        gs.approximateResults.foreach((arg_0, arg_1) -> GraphIndexBuilder.lambda$addGraphNode$0((SearchResult.NodeScore[])neighbors, index, arg_0, arg_1));
                        Arrays.sort(neighbors);
                        this.updateNeighborsOneLayer(lvl, nodeLevel.node, (SearchResult.NodeScore[])neighbors, naturalScratchPooled, (ConcurrentSkipListSet<ImmutableGraphIndex.NodeAtLevel>)inProgressBefore, concurrentScratchPooled, searchScoreProvider);
                    }
                    gs.setEntryPointsFromPreviousLayer();
                }
                result = gs.resume(this.beamWidth, this.beamWidth, 0.0f, 0.0f);
            }
            this.updateNeighborsOneLayer(0, nodeLevel.node, result.getNodes(), naturalScratchPooled, (ConcurrentSkipListSet<ImmutableGraphIndex.NodeAtLevel>)inProgressBefore, concurrentScratchPooled, searchScoreProvider);
            this.graph.markComplete(nodeLevel);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.insertionsInProgress.remove(nodeLevel);
        }
        return IntStream.rangeClosed(0, nodeLevel.level).mapToLong(this.graph::ramBytesUsedOneNode).sum();
    }

    private void updateNeighborsOneLayer(int level, int node, SearchResult.NodeScore[] neighbors, NodeArray naturalScratchPooled, ConcurrentSkipListSet<ImmutableGraphIndex.NodeAtLevel> inProgressBefore, NodeArray concurrentScratchPooled, SearchScoreProvider ssp) {
        NodeArray natural = GraphIndexBuilder.toScratchCandidates(neighbors, naturalScratchPooled);
        NodeArray concurrent = this.getConcurrentCandidates(level, node, inProgressBefore, concurrentScratchPooled, ssp.scoreFunction());
        this.updateNeighbors(level, node, natural, concurrent);
    }

    @VisibleForTesting
    public void setEntryPoint(int level, int node) {
        this.graph.updateEntryNode(new ImmutableGraphIndex.NodeAtLevel(level, node));
    }

    public void markNodeDeleted(int node) {
        this.graph.markDeleted(node);
    }

    public synchronized long removeDeletedNodes() {
        ThreadSafeGrowableBitSet toDelete = this.graph.getDeletedNodes().copy();
        int nRemoved = toDelete.cardinality();
        if (nRemoved == 0) {
            return 0L;
        }
        int currentLevel = 0;
        while (currentLevel <= this.graph.getMaxLevel()) {
            int level = currentLevel++;
            ConcurrentHashMap newEdges = new ConcurrentHashMap();
            ((ForkJoinTask)this.parallelExecutor.submit(() -> IntStream.range(0, this.graph.getIdUpperBound()).parallel().forEach(i -> {
                if (toDelete.get(i)) {
                    return;
                }
                NodesIterator it = this.graph.getNeighborsIterator(level, i);
                while (it.hasNext()) {
                    int j = it.nextInt();
                    if (!toDelete.get(j)) continue;
                    Set newEdgesForI = newEdges.computeIfAbsent(i, __ -> ConcurrentHashMap.newKeySet());
                    NodesIterator jt = this.graph.getNeighborsIterator(level, j);
                    while (jt.hasNext()) {
                        int k = jt.nextInt();
                        if (i == k || toDelete.get(k)) continue;
                        newEdgesForI.add(k);
                    }
                }
            }))).join();
            ((ForkJoinTask)this.simdExecutor.submit(() -> ((Stream)newEdges.entrySet().stream().parallel()).forEach(e -> {
                int node = (Integer)e.getKey();
                ScoreFunction sf = this.scoreProvider.searchProviderFor(node).scoreFunction();
                NodeArray candidates = new NodeArray(this.graph.getDegree(level));
                for (Integer k : (Set)e.getValue()) {
                    candidates.insertSorted(k, sf.similarityTo(k));
                }
                if (candidates.size() == 0) {
                    ThreadLocalRandom R = ThreadLocalRandom.current();
                    for (int i = 0; i < 2 * this.graph.getDegree(level); ++i) {
                        int randomNode = R.nextInt(this.graph.getIdUpperBound());
                        while (toDelete.get(randomNode)) {
                            randomNode = R.nextInt(this.graph.getIdUpperBound());
                        }
                        if (randomNode != node && !candidates.contains(randomNode) && this.graph.contains(level, randomNode)) {
                            float score = sf.similarityTo(randomNode);
                            candidates.insertSorted(randomNode, score);
                        }
                        if (candidates.size() == this.graph.getDegree(level)) break;
                    }
                }
                this.graph.replaceDeletedNeighbors(level, node, toDelete, candidates);
            }))).join();
        }
        if (toDelete.get(this.graph.entryNode().node)) {
            int newLevel;
            int newEntry = -1;
            block1: for (newLevel = this.graph.getMaxLevel(); newLevel >= 0; --newLevel) {
                NodesIterator it = this.graph.getNodes(newLevel);
                while (it.hasNext()) {
                    int i = it.nextInt();
                    if (toDelete.get(i)) continue;
                    newEntry = i;
                    break block1;
                }
            }
            this.graph.updateEntryNode(newEntry >= 0 ? new ImmutableGraphIndex.NodeAtLevel(newLevel, newEntry) : null);
        }
        long memorySize = 0L;
        assert (toDelete.cardinality() == nRemoved) : "cardinality changed";
        int i = toDelete.nextSetBit(0);
        while (i != Integer.MAX_VALUE) {
            int nDeletions = this.graph.removeNode(i);
            for (int iLayer = 0; iLayer < nDeletions; ++iLayer) {
                memorySize += this.graph.ramBytesUsedOneNode(iLayer);
            }
            i = toDelete.nextSetBit(i + 1);
        }
        return memorySize;
    }

    private void updateNeighbors(int level, int nodeId, NodeArray natural, NodeArray concurrent) {
        NodeArray toMerge = concurrent.size() == 0 ? natural : (natural.size() == 0 ? concurrent : NodeArray.merge(natural, concurrent));
        this.graph.addEdges(level, nodeId, toMerge, this.neighborOverflow);
    }

    private static NodeArray toScratchCandidates(SearchResult.NodeScore[] candidates, NodeArray scratch) {
        scratch.clear();
        for (SearchResult.NodeScore candidate : candidates) {
            scratch.addInOrder(candidate.node, candidate.score);
        }
        return scratch;
    }

    private NodeArray getConcurrentCandidates(int level, int newNode, Set<ImmutableGraphIndex.NodeAtLevel> inProgress, NodeArray scratch, ScoreFunction scoreFunction) {
        scratch.clear();
        for (ImmutableGraphIndex.NodeAtLevel n : inProgress) {
            if (n.node == newNode || n.level < level) continue;
            scratch.insertSorted(n.node, scoreFunction.similarityTo(n.node));
        }
        return scratch;
    }

    @Override
    public void close() throws IOException {
        try {
            this.searchers.close();
        }
        catch (Exception e) {
            ExceptionUtils.throwIoException(e);
        }
    }

    @Deprecated
    public void load(RandomAccessReader in) throws IOException {
        if (this.graph.size(0) != 0) {
            throw new IllegalStateException("Cannot load into a non-empty graph");
        }
        int maybeMagic = in.readInt();
        if (maybeMagic != 1978417170) {
            int version = 3;
            int size = maybeMagic;
            this.loadV3(in, size);
        } else {
            int version = in.readInt();
            if (version != 4) {
                throw new IOException("Unsupported version: " + version);
            }
            this.loadV4(in);
        }
    }

    @Deprecated
    private void loadV4(RandomAccessReader in) throws IOException {
        if (this.graph.size(0) != 0) {
            throw new IllegalStateException("Cannot load into a non-empty graph");
        }
        int layerCount = in.readInt();
        ArrayList<Integer> layerDegrees = new ArrayList<Integer>(layerCount);
        for (int level = 0; level < layerCount; ++level) {
            layerDegrees.add(in.readInt());
        }
        int entryNode = in.readInt();
        HashMap<Integer, Integer> nodeLevelMap = new HashMap<Integer, Integer>();
        for (int level = 0; level < layerCount; ++level) {
            int layerSize = in.readInt();
            for (int i = 0; i < layerSize; ++i) {
                int nodeId = in.readInt();
                int nNeighbors = in.readInt();
                SearchScoreProvider searchProvider = this.scoreProvider.searchProviderFor(nodeId);
                ScoreFunction sf = level > 0 || searchProvider.reranker() == null ? searchProvider.scoreFunction() : searchProvider.exactScoreFunction();
                NodeArray ca = new NodeArray(nNeighbors);
                for (int j = 0; j < nNeighbors; ++j) {
                    int neighbor = in.readInt();
                    float score = in.readFloat();
                    ca.addInOrder(neighbor, sf.similarityTo(neighbor));
                }
                this.graph.connectNode(level, nodeId, ca);
                nodeLevelMap.put(nodeId, level);
            }
        }
        for (Integer k : nodeLevelMap.keySet()) {
            ImmutableGraphIndex.NodeAtLevel nal = new ImmutableGraphIndex.NodeAtLevel((Integer)nodeLevelMap.get(k), k);
            this.graph.markComplete(nal);
        }
        this.graph.setDegrees(layerDegrees);
        this.graph.updateEntryNode(new ImmutableGraphIndex.NodeAtLevel(this.graph.getMaxLevel(), entryNode));
    }

    @Deprecated
    private void loadV3(RandomAccessReader in, int size) throws IOException {
        if (this.graph.size() != 0) {
            throw new IllegalStateException("Cannot load into a non-empty graph");
        }
        int entryNode = in.readInt();
        int maxDegree = in.readInt();
        for (int i = 0; i < size; ++i) {
            int nodeId = in.readInt();
            int nNeighbors = in.readInt();
            SearchScoreProvider searchProvider = this.scoreProvider.searchProviderFor(nodeId);
            ScoreFunction sf = searchProvider.reranker() == null ? searchProvider.scoreFunction() : searchProvider.exactScoreFunction();
            NodeArray ca = new NodeArray(nNeighbors);
            for (int j = 0; j < nNeighbors; ++j) {
                int neighbor = in.readInt();
                ca.addInOrder(neighbor, sf.similarityTo(neighbor));
            }
            this.graph.connectNode(0, nodeId, ca);
            this.graph.markComplete(new ImmutableGraphIndex.NodeAtLevel(0, nodeId));
        }
        this.graph.updateEntryNode(new ImmutableGraphIndex.NodeAtLevel(0, entryNode));
        this.graph.setDegrees(List.of(Integer.valueOf(maxDegree)));
    }

    @Experimental
    public static ImmutableGraphIndex buildAndMergeNewNodes(RandomAccessReader in, RandomAccessVectorValues newVectors, BuildScoreProvider buildScoreProvider, int startingNodeOffset, int[] graphToRavvOrdMap, int beamWidth, float overflowRatio, float alpha, boolean addHierarchy) throws IOException {
        VamanaDiversityProvider diversityProvider = new VamanaDiversityProvider(buildScoreProvider, alpha);
        try (OnHeapGraphIndex graph = OnHeapGraphIndex.load(in, overflowRatio, diversityProvider);){
            GraphIndexBuilder builder = new GraphIndexBuilder(buildScoreProvider, newVectors.dimension(), graph, beamWidth, overflowRatio, alpha, addHierarchy, true, PhysicalCoreExecutor.pool(), ForkJoinPool.commonPool());
            Supplier<RandomAccessVectorValues> vv = newVectors.threadLocalSupplier();
            ((ForkJoinTask)PhysicalCoreExecutor.pool().submit(() -> IntStream.range(startingNodeOffset, newVectors.size()).parallel().forEach(arg_0 -> GraphIndexBuilder.lambda$buildAndMergeNewNodes$1(builder, (Supplier)vv, graphToRavvOrdMap, arg_0)))).join();
            builder.cleanup();
            ImmutableGraphIndex immutableGraphIndex = builder.getGraph();
            return immutableGraphIndex;
        }
    }

    private static /* synthetic */ void lambda$buildAndMergeNewNodes$1(GraphIndexBuilder builder, Supplier vv, int[] graphToRavvOrdMap, int ord) {
        builder.addGraphNode(ord, ((RandomAccessVectorValues)vv.get()).getVector(graphToRavvOrdMap[ord]));
    }

    private static /* synthetic */ void lambda$addGraphNode$0(SearchResult.NodeScore[] neighbors, AtomicInteger index, int neighbor, float score) {
        neighbors[index.getAndIncrement()] = new SearchResult.NodeScore(neighbor, score);
    }

    private /* synthetic */ void lambda$build$1(Supplier vv, int node) {
        this.addGraphNode(node, ((RandomAccessVectorValues)vv.get()).getVector(node));
    }

    private static class ExcludingBits
    implements Bits {
        private final int excluded;

        public ExcludingBits(int excluded) {
            this.excluded = excluded;
        }

        @Override
        public boolean get(int index) {
            return index != this.excluded;
        }
    }
}

