/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.disk.ReaderSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class MappedChunkReader
implements RandomAccessReader {
    private static final long CHUNK_SIZE = Integer.MAX_VALUE;
    private final FileChannel channel;
    private final long fileSize;
    private final ByteOrder byteOrder;
    private long position;
    private ByteBuffer currentBuffer;
    private long currentChunkStart;

    public MappedChunkReader(FileChannel channel, ByteOrder byteOrder) throws IOException {
        this.channel = channel;
        this.byteOrder = byteOrder;
        this.fileSize = channel.size();
        this.position = 0L;
        this.mapChunk(0L);
    }

    private void mapChunk(long chunkStart) throws IOException {
        long size = Math.min(Integer.MAX_VALUE, this.fileSize - chunkStart);
        this.currentBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, chunkStart, size).order(this.byteOrder);
        this.currentChunkStart = chunkStart;
    }

    private void ensureAvailable(int size) throws IOException {
        if (this.position < this.currentChunkStart || this.position + (long)size > this.currentChunkStart + (long)this.currentBuffer.capacity()) {
            this.mapChunk(this.position / Integer.MAX_VALUE * Integer.MAX_VALUE);
        }
        this.currentBuffer.position((int)(this.position - this.currentChunkStart));
    }

    @Override
    public void seek(long offset) {
        this.position = offset;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public int readInt() {
        try {
            this.ensureAvailable(4);
            int v = this.currentBuffer.getInt();
            this.position += 4L;
            return v;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readLong() {
        try {
            this.ensureAvailable(8);
            long v = this.currentBuffer.getLong();
            this.position += 8L;
            return v;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public float readFloat() {
        try {
            this.ensureAvailable(4);
            float v = this.currentBuffer.getFloat();
            this.position += 4L;
            return v;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readFully(byte[] b) {
        try {
            int offset = 0;
            while (offset < b.length) {
                this.ensureAvailable(1);
                int toRead = Math.min(b.length - offset, this.currentBuffer.remaining());
                this.currentBuffer.get(b, offset, toRead);
                offset += toRead;
                this.position += (long)toRead;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readFully(ByteBuffer buffer) {
        try {
            while (buffer.hasRemaining()) {
                this.ensureAvailable(1);
                int toRead = Math.min(buffer.remaining(), this.currentBuffer.remaining());
                ByteBuffer slice = this.currentBuffer.slice();
                slice.limit(toRead);
                buffer.put(slice);
                this.currentBuffer.position(this.currentBuffer.position() + toRead);
                this.position += (long)toRead;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readFully(long[] vector) {
        ByteBuffer tmp = ByteBuffer.allocate(vector.length * 8).order(this.byteOrder);
        this.readFully(tmp);
        tmp.flip().asLongBuffer().get(vector);
    }

    @Override
    public void read(int[] ints, int offset, int count) {
        ByteBuffer tmp = ByteBuffer.allocate(count * 4).order(this.byteOrder);
        this.readFully(tmp);
        tmp.flip().asIntBuffer().get(ints, offset, count);
    }

    @Override
    public void read(float[] floats, int offset, int count) {
        ByteBuffer tmp = ByteBuffer.allocate(count * 4).order(this.byteOrder);
        this.readFully(tmp);
        tmp.flip().asFloatBuffer().get(floats, offset, count);
    }

    @Override
    public long length() {
        return this.fileSize;
    }

    @Override
    public void close() {
    }

    public static class Supplier
    implements ReaderSupplier {
        private final FileChannel channel;

        public Supplier(Path path) throws IOException {
            this.channel = FileChannel.open(path, StandardOpenOption.READ);
        }

        @Override
        public RandomAccessReader get() {
            try {
                return new MappedChunkReader(this.channel, ByteOrder.BIG_ENDIAN);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

