/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import java.util.Arrays;
import java.util.Objects;

public final class SearchResult {
    private final NodeScore[] nodes;
    private final int visitedCount;
    private final int expandedCount;
    private final int expandedCountL0;
    private final int rerankedCount;
    private final float worstApproximateScoreInTopK;

    public SearchResult(NodeScore[] nodes, int visitedCount, int expandedCount, int expandedCountL0, int rerankedCount, float worstApproximateScoreInTopK) {
        this.nodes = nodes;
        this.visitedCount = visitedCount;
        this.expandedCount = expandedCount;
        this.expandedCountL0 = expandedCountL0;
        this.rerankedCount = rerankedCount;
        this.worstApproximateScoreInTopK = worstApproximateScoreInTopK;
    }

    public NodeScore[] getNodes() {
        return this.nodes;
    }

    public int getVisitedCount() {
        return this.visitedCount;
    }

    public int getExpandedCount() {
        return this.expandedCount;
    }

    public int getExpandedCountBaseLayer() {
        return this.expandedCountL0;
    }

    public int getRerankedCount() {
        return this.rerankedCount;
    }

    public float getWorstApproximateScoreInTopK() {
        return this.worstApproximateScoreInTopK;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult that = (SearchResult)o;
        return this.visitedCount == that.visitedCount && this.rerankedCount == that.rerankedCount && Float.compare(this.worstApproximateScoreInTopK, that.worstApproximateScoreInTopK) == 0 && Objects.deepEquals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nodes), this.visitedCount, this.rerankedCount, Float.valueOf(this.worstApproximateScoreInTopK));
    }

    public static final class NodeScore
    implements Comparable<NodeScore> {
        public final int node;
        public final float score;

        public NodeScore(int node, float score) {
            this.node = node;
            this.score = score;
        }

        public String toString() {
            return String.format("NodeScore(%d, %s)", this.node, Float.valueOf(this.score));
        }

        @Override
        public int compareTo(NodeScore o) {
            int scoreCompare = Float.compare(o.score, this.score);
            return scoreCompare != 0 ? scoreCompare : Integer.compare(this.node, o.node);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeScore nodeScore = (NodeScore)o;
            return this.node == nodeScore.node && Float.compare(this.score, nodeScore.score) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.node, Float.valueOf(this.score));
        }
    }
}

