/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.util.BoundedLongHeap;
import io.github.jbellis.jvector.util.NumericUtils;
import org.apache.commons.math3.stat.StatUtils;

interface ScoreTracker {
    public static final ScoreTracker NO_OP = new NoOpTracker();

    public void track(float var1);

    public boolean shouldStop();

    public static class NoOpTracker
    implements ScoreTracker {
        @Override
        public void track(float score) {
        }

        @Override
        public boolean shouldStop() {
            return false;
        }
    }

    public static class RelaxedMonotonicityTracker
    implements ScoreTracker {
        static final double SIGMA_FACTOR = 1.75;
        private final double[] recentScores;
        private int recentEntryIndex;
        BoundedLongHeap bestScores;
        private int observationCount;
        private double mean;
        private double dSquared;

        RelaxedMonotonicityTracker(int bestScoresTracked) {
            int factor = (int)Math.round(Math.sqrt((double)bestScoresTracked / 2.0));
            this.recentScores = new double[200 * factor];
            this.bestScores = new BoundedLongHeap(bestScoresTracked);
            this.mean = 0.0;
            this.dSquared = 0.0;
        }

        @Override
        public void track(float score) {
            this.bestScores.push(NumericUtils.floatToSortableInt(score));
            ++this.observationCount;
            if (this.observationCount <= this.recentScores.length) {
                double meanDelta = ((double)score - this.mean) / (double)this.observationCount;
                double newMean = this.mean + meanDelta;
                double dSquaredDelta = ((double)score - newMean) * ((double)score - this.mean);
                double newDSquared = this.dSquared + dSquaredDelta;
                this.mean = newMean;
                this.dSquared = newDSquared;
            } else {
                double oldScore = this.recentScores[this.recentEntryIndex];
                double meanDelta = ((double)score - oldScore) / (double)this.recentScores.length;
                double newMean = this.mean + meanDelta;
                double dSquaredDelta = ((double)score - oldScore) * ((double)score - newMean + oldScore - this.mean);
                double newDSquared = this.dSquared + dSquaredDelta;
                this.mean = newMean;
                this.dSquared = newDSquared;
            }
            this.recentScores[this.recentEntryIndex] = score;
            this.recentEntryIndex = (this.recentEntryIndex + 1) % this.recentScores.length;
        }

        @Override
        public boolean shouldStop() {
            double worstBestScore;
            if (this.observationCount < this.recentScores.length) {
                return false;
            }
            double std = Math.sqrt(this.dSquared / (double)(this.recentScores.length - 1));
            double windowPercentile = this.mean + 1.75 * std;
            return windowPercentile < (worstBestScore = (double)NumericUtils.sortableIntToFloat((int)this.bestScores.top()));
        }
    }

    public static class TwoPhaseTracker
    implements ScoreTracker {
        static final int RECENT_SCORES_TRACKED = 500;
        static final int BEST_SCORES_TRACKED = 100;
        private final double[] recentScores = new double[500];
        private int recentEntryIndex;
        BoundedLongHeap bestScores = new BoundedLongHeap(100);
        private int observationCount;
        private final double threshold;

        TwoPhaseTracker(double threshold) {
            this.threshold = threshold;
        }

        @Override
        public void track(float score) {
            this.bestScores.push(NumericUtils.floatToSortableInt(score));
            this.recentScores[this.recentEntryIndex] = score;
            this.recentEntryIndex = (this.recentEntryIndex + 1) % this.recentScores.length;
            ++this.observationCount;
        }

        @Override
        public boolean shouldStop() {
            double worstBestScore;
            if (this.observationCount < 500) {
                return false;
            }
            if (this.observationCount % 100 != 0) {
                return false;
            }
            double windowMedian = StatUtils.percentile((double[])this.recentScores, (double)99.0);
            return windowMedian < (worstBestScore = (double)NumericUtils.sortableIntToFloat((int)this.bestScores.top())) && windowMedian < this.threshold;
        }
    }
}

