/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.BufferedRandomAccessWriter;
import io.github.jbellis.jvector.disk.RandomAccessWriter;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.OnHeapGraphIndex;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.Header;
import io.github.jbellis.jvector.graph.disk.OrdinalMapper;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import io.github.jbellis.jvector.graph.disk.feature.InlineVectors;
import io.github.jbellis.jvector.graph.disk.feature.NVQ;
import io.github.jbellis.jvector.graph.disk.feature.SeparatedFeature;
import io.github.jbellis.jvector.graph.disk.feature.SeparatedNVQ;
import io.github.jbellis.jvector.graph.disk.feature.SeparatedVectors;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.agrona.collections.Int2IntHashMap;

public class OnDiskGraphIndexWriter
implements Closeable {
    private final int version;
    private final GraphIndex graph;
    private final GraphIndex.View view;
    private final OrdinalMapper ordinalMapper;
    private final int dimension;
    private final EnumMap<FeatureId, Feature> featureMap;
    private final RandomAccessWriter out;
    private final long startOffset;
    private final int headerSize;
    private volatile int maxOrdinalWritten = -1;
    private final List<Feature> inlineFeatures;

    private OnDiskGraphIndexWriter(RandomAccessWriter out, int version, long startOffset, GraphIndex graph, OrdinalMapper oldToNewOrdinals, int dimension, EnumMap<FeatureId, Feature> features) {
        if (graph.getMaxLevel() > 0 && version < 4) {
            throw new IllegalArgumentException("Multilayer graphs must be written with version 4 or higher");
        }
        this.version = version;
        this.graph = graph;
        this.view = graph instanceof OnHeapGraphIndex ? ((OnHeapGraphIndex)graph).getFrozenView() : graph.getView();
        this.ordinalMapper = oldToNewOrdinals;
        this.dimension = dimension;
        this.featureMap = features;
        this.inlineFeatures = features.values().stream().filter(f -> !(f instanceof SeparatedFeature)).collect(Collectors.toList());
        this.out = out;
        this.startOffset = startOffset;
        List<CommonHeader.LayerInfo> layerInfo = CommonHeader.LayerInfo.fromGraph(graph, this.ordinalMapper);
        CommonHeader ch = new CommonHeader(version, dimension, 0, layerInfo, 0);
        Header placeholderHeader = new Header(ch, this.featureMap);
        this.headerSize = placeholderHeader.size();
    }

    public Set<FeatureId> getFeatureSet() {
        return this.featureMap.keySet();
    }

    @Override
    public synchronized void close() throws IOException {
        this.view.close();
        this.out.close();
    }

    public RandomAccessWriter getOutput() {
        return this.out;
    }

    public synchronized void writeInline(int ordinal, Map<FeatureId, Feature.State> stateMap) throws IOException {
        for (FeatureId featureId : stateMap.keySet()) {
            if (this.featureMap.containsKey((Object)featureId)) continue;
            throw new IllegalArgumentException(String.format("Feature %s not configured for index", new Object[]{featureId}));
        }
        this.out.seek(this.featureOffsetForOrdinal(ordinal));
        for (Feature feature : this.inlineFeatures) {
            Feature.State state = stateMap.get((Object)feature.id());
            if (state == null) {
                this.out.seek(this.out.position() + (long)feature.featureSize());
                continue;
            }
            feature.writeInline(this.out, state);
        }
        this.maxOrdinalWritten = Math.max(this.maxOrdinalWritten, ordinal);
    }

    public int getMaxOrdinal() {
        return this.maxOrdinalWritten;
    }

    private long featureOffsetForOrdinal(int ordinal) {
        int edgeSize = 4 * (1 + this.graph.getDegree(0));
        long inlineBytes = (long)ordinal * (long)(4 + this.inlineFeatures.stream().mapToInt(Feature::featureSize).sum() + edgeSize);
        return this.startOffset + (long)this.headerSize + inlineBytes + 4L;
    }

    private boolean isSeparated(Feature feature) {
        return feature instanceof SeparatedFeature;
    }

    public synchronized void write(Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers) throws IOException {
        Object ohgi;
        if (this.graph instanceof OnHeapGraphIndex && ((OnHeapGraphIndex)(ohgi = (OnHeapGraphIndex)this.graph)).getDeletedNodes().cardinality() > 0) {
            throw new IllegalArgumentException("Run builder.cleanup() before writing the graph");
        }
        for (FeatureId featureId : featureStateSuppliers.keySet()) {
            if (this.featureMap.containsKey((Object)featureId)) continue;
            throw new IllegalArgumentException(String.format("Feature %s not configured for index", new Object[]{featureId}));
        }
        if (this.ordinalMapper.maxOrdinal() < this.graph.size() - 1) {
            String msg = String.format("Ordinal mapper from [0..%d] does not cover all nodes in the graph of size %d", this.ordinalMapper.maxOrdinal(), this.graph.size());
            throw new IllegalStateException(msg);
        }
        this.writeHeader();
        for (int newOrdinal = 0; newOrdinal <= this.ordinalMapper.maxOrdinal(); ++newOrdinal) {
            int n;
            int originalOrdinal = this.ordinalMapper.newToOld(newOrdinal);
            if (originalOrdinal == Integer.MIN_VALUE) {
                this.out.writeInt(-1);
                for (Feature feature : this.inlineFeatures) {
                    this.out.seek(this.out.position() + (long)feature.featureSize());
                }
                this.out.writeInt(0);
                for (int n2 = 0; n2 < this.graph.maxDegree(); ++n2) {
                    this.out.writeInt(-1);
                }
                continue;
            }
            if (!this.graph.containsNode(originalOrdinal)) {
                String msg = String.format("Ordinal mapper mapped new ordinal %s to non-existing node %s", newOrdinal, originalOrdinal);
                throw new IllegalStateException(msg);
            }
            this.out.writeInt(newOrdinal);
            assert (this.out.position() == this.featureOffsetForOrdinal(newOrdinal)) : String.format("%d != %d", this.out.position(), this.featureOffsetForOrdinal(newOrdinal));
            for (Feature feature : this.inlineFeatures) {
                IntFunction<Feature.State> supplier = featureStateSuppliers.get((Object)feature.id());
                if (supplier == null) {
                    this.out.seek(this.out.position() + (long)feature.featureSize());
                    continue;
                }
                feature.writeInline(this.out, supplier.apply(originalOrdinal));
            }
            NodesIterator neighbors = this.view.getNeighborsIterator(0, originalOrdinal);
            if (neighbors.size() > this.graph.getDegree(0)) {
                String msg = String.format("Node %d has more neighbors %d than the graph's max degree %d -- run Builder.cleanup()!", originalOrdinal, neighbors.size(), this.graph.getDegree(0));
                throw new IllegalStateException(msg);
            }
            this.out.writeInt(neighbors.size());
            for (n = 0; n < neighbors.size(); ++n) {
                int newNeighborOrdinal = this.ordinalMapper.oldToNew(neighbors.nextInt());
                if (newNeighborOrdinal < 0 || newNeighborOrdinal > this.ordinalMapper.maxOrdinal()) {
                    String msg = String.format("Neighbor ordinal out of bounds: %d/%d", newNeighborOrdinal, this.ordinalMapper.maxOrdinal());
                    throw new IllegalStateException(msg);
                }
                this.out.writeInt(newNeighborOrdinal);
            }
            assert (!neighbors.hasNext());
            while (n < this.graph.getDegree(0)) {
                this.out.writeInt(-1);
                ++n;
            }
        }
        for (int level = 1; level <= this.graph.getMaxLevel(); ++level) {
            int layerSize = this.graph.size(level);
            int layerDegree = this.graph.getDegree(level);
            int nodesWritten = 0;
            NodesIterator it = this.graph.getNodes(level);
            while (it.hasNext()) {
                int n;
                int originalOrdinal = it.nextInt();
                this.out.writeInt(this.ordinalMapper.oldToNew(originalOrdinal));
                NodesIterator neighbors = this.view.getNeighborsIterator(level, originalOrdinal);
                this.out.writeInt(neighbors.size());
                for (n = 0; n < neighbors.size(); ++n) {
                    this.out.writeInt(this.ordinalMapper.oldToNew(neighbors.nextInt()));
                }
                assert (!neighbors.hasNext()) : "Mismatch between neighbor's reported size and actual size";
                while (n < layerDegree) {
                    this.out.writeInt(-1);
                    ++n;
                }
                ++nodesWritten;
            }
            if (nodesWritten == layerSize) continue;
            throw new IllegalStateException("Mismatch between layer size and nodes written");
        }
        for (Map.Entry<FeatureId, Feature> featureEntry : this.featureMap.entrySet()) {
            if (!this.isSeparated(featureEntry.getValue())) continue;
            FeatureId fid = featureEntry.getKey();
            IntFunction<Feature.State> supplier = featureStateSuppliers.get((Object)fid);
            if (supplier == null) {
                throw new IllegalStateException("Supplier for feature " + String.valueOf((Object)fid) + " not found");
            }
            SeparatedFeature feature = (SeparatedFeature)featureEntry.getValue();
            feature.setOffset(this.out.position());
            for (int newOrdinal = 0; newOrdinal <= this.ordinalMapper.maxOrdinal(); ++newOrdinal) {
                int originalOrdinal = this.ordinalMapper.newToOld(newOrdinal);
                if (originalOrdinal != Integer.MIN_VALUE) {
                    feature.writeSeparately(this.out, supplier.apply(originalOrdinal));
                    continue;
                }
                this.out.seek(this.out.position() + (long)feature.featureSize());
            }
        }
        long currentPosition = this.out.position();
        this.writeHeader();
        this.out.seek(currentPosition);
        this.out.flush();
    }

    public synchronized void writeHeader() throws IOException {
        this.out.seek(this.startOffset);
        List<CommonHeader.LayerInfo> layerInfo = CommonHeader.LayerInfo.fromGraph(this.graph, this.ordinalMapper);
        CommonHeader commonHeader = new CommonHeader(this.version, this.dimension, this.ordinalMapper.oldToNew(this.view.entryNode().node), layerInfo, this.ordinalMapper.maxOrdinal() + 1);
        Header header = new Header(commonHeader, this.featureMap);
        header.write(this.out);
        this.out.flush();
        assert (this.out.position() == this.startOffset + (long)this.headerSize) : String.format("%d != %d", this.out.position(), this.startOffset + (long)this.headerSize);
    }

    public static Map<Integer, Integer> sequentialRenumbering(GraphIndex graph) {
        Int2IntHashMap int2IntHashMap;
        block9: {
            GraphIndex.View view = graph.getView();
            try {
                Int2IntHashMap oldToNewMap = new Int2IntHashMap(-1);
                int nextOrdinal = 0;
                for (int i = 0; i < view.getIdUpperBound(); ++i) {
                    if (!graph.containsNode(i)) continue;
                    oldToNewMap.put(i, nextOrdinal++);
                }
                int2IntHashMap = oldToNewMap;
                if (view == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (view != null) {
                        try {
                            view.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            view.close();
        }
        return int2IntHashMap;
    }

    public synchronized long checksum() throws IOException {
        long endOffset = this.out.position();
        return this.out.checksum(this.startOffset, endOffset);
    }

    public static class Builder {
        private final GraphIndex graphIndex;
        private final EnumMap<FeatureId, Feature> features;
        private final RandomAccessWriter out;
        private OrdinalMapper ordinalMapper;
        private long startOffset;
        private int version;

        public Builder(GraphIndex graphIndex, Path outPath) throws FileNotFoundException {
            this(graphIndex, new BufferedRandomAccessWriter(outPath));
        }

        public Builder(GraphIndex graphIndex, RandomAccessWriter out) {
            this.graphIndex = graphIndex;
            this.out = out;
            this.features = new EnumMap(FeatureId.class);
            this.version = 4;
        }

        public Builder withVersion(int version) {
            if (version > 4) {
                throw new IllegalArgumentException("Unsupported version: " + version);
            }
            this.version = version;
            return this;
        }

        public Builder with(Feature feature) {
            this.features.put(feature.id(), feature);
            return this;
        }

        public Builder withMapper(OrdinalMapper ordinalMapper) {
            this.ordinalMapper = ordinalMapper;
            return this;
        }

        public Builder withStartOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        public OnDiskGraphIndexWriter build() throws IOException {
            int dimension;
            if (!(this.version >= 3 || this.features.containsKey((Object)FeatureId.INLINE_VECTORS) && this.features.size() <= 1)) {
                throw new IllegalArgumentException("Only INLINE_VECTORS is supported until version 3");
            }
            if (this.features.containsKey((Object)FeatureId.INLINE_VECTORS)) {
                dimension = ((InlineVectors)this.features.get((Object)FeatureId.INLINE_VECTORS)).dimension();
            } else if (this.features.containsKey((Object)FeatureId.NVQ_VECTORS)) {
                dimension = ((NVQ)this.features.get((Object)FeatureId.NVQ_VECTORS)).dimension();
            } else if (this.features.containsKey((Object)FeatureId.SEPARATED_VECTORS)) {
                dimension = ((SeparatedVectors)this.features.get((Object)FeatureId.SEPARATED_VECTORS)).dimension();
            } else if (this.features.containsKey((Object)FeatureId.SEPARATED_NVQ)) {
                dimension = ((SeparatedNVQ)this.features.get((Object)FeatureId.SEPARATED_NVQ)).dimension();
            } else {
                throw new IllegalArgumentException("Inline or separated vector feature must be provided");
            }
            if (this.ordinalMapper == null) {
                this.ordinalMapper = new OrdinalMapper.MapMapper(OnDiskGraphIndexWriter.sequentialRenumbering(this.graphIndex));
            }
            return new OnDiskGraphIndexWriter(this.out, this.version, this.startOffset, this.graphIndex, this.ordinalMapper, dimension, this.features);
        }

        public Builder withMap(Map<Integer, Integer> oldToNewOrdinals) {
            return this.withMapper(new OrdinalMapper.MapMapper(oldToNewOrdinals));
        }

        public Feature getFeature(FeatureId featureId) {
            return this.features.get((Object)featureId);
        }
    }
}

