/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector;

import io.github.jbellis.jvector.util.RamUsageEstimator;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.lang.foreign.MemorySegment;
import java.nio.Buffer;

public final class MemorySegmentVectorFloat
implements VectorFloat<MemorySegment> {
    private final MemorySegment segment;

    MemorySegmentVectorFloat(int length) {
        this.segment = MemorySegment.ofArray(new float[length]);
    }

    MemorySegmentVectorFloat(Buffer buffer) {
        this(buffer.remaining());
        this.segment.copyFrom(MemorySegment.ofBuffer(buffer));
    }

    MemorySegmentVectorFloat(float[] data) {
        this.segment = MemorySegment.ofArray(data);
    }

    @Override
    public long ramBytesUsed() {
        int OH_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        int REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        return (long)(OH_BYTES + REF_BYTES) + this.segment.byteSize();
    }

    @Override
    public MemorySegment get() {
        return this.segment;
    }

    @Override
    public float get(int n) {
        return ((float[])this.segment.heapBase().get())[n];
    }

    @Override
    public void set(int n, float value) {
        ((float[])this.segment.heapBase().get())[n] = value;
    }

    @Override
    public void zero() {
        this.segment.fill((byte)0);
    }

    @Override
    public int length() {
        return (int)(this.segment.byteSize() / 4L);
    }

    @Override
    public int offset(int i) {
        return i * 4;
    }

    @Override
    public VectorFloat<MemorySegment> copy() {
        MemorySegmentVectorFloat copy = new MemorySegmentVectorFloat(this.length());
        copy.copyFrom(this, 0, 0, this.length());
        return copy;
    }

    @Override
    public void copyFrom(VectorFloat<?> src, int srcOffset, int destOffset, int length) {
        MemorySegmentVectorFloat csrc = (MemorySegmentVectorFloat)src;
        this.segment.asSlice((long)destOffset * 4L, (long)length * 4L).copyFrom(csrc.segment.asSlice((long)srcOffset * 4L, (long)length * 4L));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < Math.min(this.length(), 25); ++i) {
            sb.append(this.get(i));
            if (i >= this.length() - 1) continue;
            sb.append(", ");
        }
        if (this.length() > 25) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemorySegmentVectorFloat that = (MemorySegmentVectorFloat)o;
        return this.segment.mismatch(that.segment) == -1L;
    }

    public int hashCode() {
        return this.segment.hashCode();
    }
}

