/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.Feature;
import io.github.jbellis.jvector.graph.disk.FeatureId;
import io.github.jbellis.jvector.graph.disk.LVQPackedVectors;
import io.github.jbellis.jvector.graph.disk.OnDiskGraphIndex;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.pq.LocallyAdaptiveVectorQuantization;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.ByteSequence;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;

public class LVQ
implements Feature {
    private final LocallyAdaptiveVectorQuantization lvq;

    public LVQ(LocallyAdaptiveVectorQuantization lvq) {
        this.lvq = lvq;
    }

    @Override
    public FeatureId id() {
        return FeatureId.LVQ;
    }

    @Override
    public int headerSize() {
        return this.lvq.compressorSize();
    }

    @Override
    public int inlineSize() {
        return this.lvq.compressedVectorSize();
    }

    public int dimension() {
        return this.lvq.globalMean.length();
    }

    static LVQ load(CommonHeader header, RandomAccessReader reader) {
        try {
            return new LVQ(LocallyAdaptiveVectorQuantization.load(reader));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeHeader(DataOutput out) throws IOException {
        this.lvq.write(out);
    }

    @Override
    public void writeInline(DataOutput out, Feature.State state_) throws IOException {
        State state = (State)state_;
        state.vector.writePacked(out);
    }

    ScoreFunction.ExactScoreFunction rerankerFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf, OnDiskGraphIndex.View view) {
        return this.lvq.scoreFunctionFrom(queryVector, vsf, new PackedVectors(view));
    }

    public static class State
    implements Feature.State {
        public final LocallyAdaptiveVectorQuantization.QuantizedVector vector;

        public State(LocallyAdaptiveVectorQuantization.QuantizedVector vector) {
            this.vector = vector;
        }
    }

    private class PackedVectors
    implements LVQPackedVectors {
        private final OnDiskGraphIndex.View view;

        public PackedVectors(OnDiskGraphIndex.View view) {
            this.view = view;
        }

        @Override
        public LocallyAdaptiveVectorQuantization.PackedVector getPackedVector(int ordinal) {
            RandomAccessReader reader = this.view.inlineReaderForNode(ordinal, FeatureId.LVQ);
            try {
                float bias = reader.readFloat();
                float scale = reader.readFloat();
                ByteSequence<?> packed = OnDiskGraphIndex.vectorTypeSupport.readByteSequence(reader, LVQ.this.lvq.compressedVectorSize() - 8);
                return new LocallyAdaptiveVectorQuantization.PackedVector(packed, bias, scale);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

