/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.annotations.Experimental;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodeQueue;
import io.github.jbellis.jvector.graph.NodeSimilarity;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.ScoreTracker;
import io.github.jbellis.jvector.graph.SearchResult;
import io.github.jbellis.jvector.util.BitSet;
import io.github.jbellis.jvector.util.Bits;
import io.github.jbellis.jvector.util.BoundedLongHeap;
import io.github.jbellis.jvector.util.GrowableBitSet;
import io.github.jbellis.jvector.util.GrowableLongHeap;
import io.github.jbellis.jvector.util.SparseFixedBitSet;
import io.github.jbellis.jvector.vector.VectorEncoding;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import java.util.Arrays;
import java.util.Comparator;

public class GraphSearcher<T> {
    private final GraphIndex.View<T> view;
    private final NodeQueue candidates;
    private final BitSet visited;
    private final NodeQueue evictedResults;
    private NodeSimilarity.ScoreFunction scoreFunction;
    private NodeSimilarity.Reranker reranker;
    private Bits acceptOrds;

    GraphSearcher(GraphIndex.View<T> view, BitSet visited) {
        this.view = view;
        this.candidates = new NodeQueue(new GrowableLongHeap(100), NodeQueue.Order.MAX_HEAP);
        this.evictedResults = new NodeQueue(new GrowableLongHeap(100), NodeQueue.Order.MAX_HEAP);
        this.visited = visited;
    }

    public static <T> SearchResult search(T targetVector, int topK, RandomAccessVectorValues<T> vectors, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction, GraphIndex<T> graph, Bits acceptOrds) {
        SearchResult searchResult;
        block8: {
            GraphIndex.View<T> view = graph.getView();
            try {
                GraphSearcher<T> searcher = new Builder<T>(view).withConcurrentUpdates().build();
                NodeSimilarity.ExactScoreFunction scoreFunction = i -> {
                    switch (vectorEncoding) {
                        case BYTE: {
                            return similarityFunction.compare((byte[])targetVector, (byte[])vectors.vectorValue(i));
                        }
                        case FLOAT32: {
                            return similarityFunction.compare((float[])targetVector, (float[])vectors.vectorValue(i));
                        }
                    }
                    throw new RuntimeException("Unsupported vector encoding: " + String.valueOf((Object)vectorEncoding));
                };
                searchResult = searcher.search(scoreFunction, null, topK, acceptOrds);
                if (view == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (view != null) {
                        try {
                            view.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            view.close();
        }
        return searchResult;
    }

    @Experimental
    public SearchResult search(NodeSimilarity.ScoreFunction scoreFunction, NodeSimilarity.Reranker reranker, int topK, float threshold, float rerankFloor, Bits acceptOrds) {
        return this.searchInternal(scoreFunction, reranker, topK, threshold, rerankFloor, this.view.entryNode(), acceptOrds);
    }

    public SearchResult search(NodeSimilarity.ScoreFunction scoreFunction, NodeSimilarity.Reranker reranker, int topK, float threshold, Bits acceptOrds) {
        return this.search(scoreFunction, reranker, topK, threshold, 0.0f, acceptOrds);
    }

    public SearchResult search(NodeSimilarity.ScoreFunction scoreFunction, NodeSimilarity.Reranker reranker, int topK, Bits acceptOrds) {
        return this.search(scoreFunction, reranker, topK, 0.0f, acceptOrds);
    }

    SearchResult searchInternal(NodeSimilarity.ScoreFunction scoreFunction, NodeSimilarity.Reranker reranker, int topK, float threshold, float rerankFloor, int ep, Bits rawAcceptOrds) {
        if (!scoreFunction.isExact() && reranker == null) {
            throw new IllegalArgumentException("Either scoreFunction must be exact, or reranker must not be null");
        }
        if (rawAcceptOrds == null) {
            throw new IllegalArgumentException("Use MatchAllBits to indicate that all ordinals are accepted, instead of null");
        }
        this.scoreFunction = scoreFunction;
        this.reranker = reranker;
        this.acceptOrds = Bits.intersectionOf(rawAcceptOrds, this.view.liveNodes());
        int capacity = this.view.size();
        this.evictedResults.clear();
        this.candidates.clear();
        if (this.visited.length() < capacity && !(this.visited instanceof GrowableBitSet)) {
            throw new IllegalArgumentException(String.format("Unexpected visited type: %s. Encountering this means that the graph changed while being searched, and the Searcher was not built withConcurrentUpdates()", this.visited.getClass().getName()));
        }
        this.visited.clear();
        if (ep < 0) {
            return new SearchResult(new SearchResult.NodeScore[0], this.visited, 0);
        }
        float score = scoreFunction.similarityTo(ep);
        this.visited.set(ep);
        this.candidates.push(ep, score);
        SearchResult sr = this.resume(topK, threshold, rerankFloor);
        return new SearchResult(sr.getNodes(), sr.getVisited(), sr.getVisitedCount() + 1);
    }

    @Experimental
    public SearchResult resume(int additionalK, float threshold, float rerankFloor) {
        float topCandidateScore;
        Bits previouslyEvicted;
        NodeQueue resultsQueue = new NodeQueue(new BoundedLongHeap(Math.min(1024, additionalK), additionalK), NodeQueue.Order.MIN_HEAP);
        int numVisited = 0;
        float minAcceptedSimilarity = Float.NEGATIVE_INFINITY;
        ScoreTracker scoreTracker = threshold > 0.0f ? new ScoreTracker.NormalDistributionTracker(threshold) : ScoreTracker.NO_OP;
        Bits bits = previouslyEvicted = this.evictedResults.size() > 0 ? new GrowableBitSet(this.view.size()) : Bits.NONE;
        while (this.evictedResults.size() > 0) {
            float score = this.evictedResults.topScore();
            int node = this.evictedResults.pop();
            this.candidates.push(node, score);
            ((GrowableBitSet)previouslyEvicted).set(node);
        }
        this.evictedResults.clear();
        while (this.candidates.size() > 0 && !((topCandidateScore = this.candidates.topScore()) < minAcceptedSimilarity) && !scoreTracker.shouldStop(numVisited)) {
            int topCandidateNode = this.candidates.pop();
            if (this.acceptOrds.get(topCandidateNode) && topCandidateScore >= threshold) {
                boolean added;
                if (resultsQueue.size() < additionalK) {
                    resultsQueue.push(topCandidateNode, topCandidateScore);
                    added = true;
                } else if (topCandidateScore > resultsQueue.topScore()) {
                    int evictedNode = resultsQueue.topNode();
                    float evictedScore = resultsQueue.topScore();
                    this.evictedResults.push(evictedNode, evictedScore);
                    resultsQueue.push(topCandidateNode, topCandidateScore);
                    added = true;
                } else {
                    added = false;
                }
                if (added && resultsQueue.size() >= additionalK) {
                    minAcceptedSimilarity = resultsQueue.topScore();
                }
            }
            if (previouslyEvicted.get(topCandidateNode)) continue;
            NodesIterator it = this.view.getNeighborsIterator(topCandidateNode);
            while (it.hasNext()) {
                int friendOrd = it.nextInt();
                if (this.visited.getAndSet(friendOrd)) continue;
                ++numVisited;
                float friendSimilarity = this.scoreFunction.similarityTo(friendOrd);
                scoreTracker.track(friendSimilarity);
                this.candidates.push(friendOrd, friendSimilarity);
            }
        }
        assert (resultsQueue.size() <= additionalK);
        SearchResult.NodeScore[] nodes = GraphSearcher.extractScores(this.scoreFunction, this.reranker, resultsQueue, rerankFloor);
        return new SearchResult(nodes, this.visited, numVisited);
    }

    @Experimental
    public SearchResult resume(int additionalK) {
        return this.resume(additionalK, 0.0f, 0.0f);
    }

    private static SearchResult.NodeScore[] extractScores(NodeSimilarity.ScoreFunction sf, NodeSimilarity.Reranker reranker, NodeQueue resultsQueue, float rerankFloor) {
        SearchResult.NodeScore[] nodes;
        if (sf.isExact()) {
            nodes = new SearchResult.NodeScore[resultsQueue.size()];
            for (int i = nodes.length - 1; i >= 0; --i) {
                float nScore = resultsQueue.topScore();
                int n = resultsQueue.pop();
                nodes[i] = new SearchResult.NodeScore(n, nScore);
            }
        } else {
            nodes = resultsQueue.nodesCopy(reranker::similarityTo, rerankFloor);
            Arrays.sort(nodes, 0, nodes.length, Comparator.comparingDouble(nodeScore -> nodeScore.score).reversed());
            resultsQueue.clear();
        }
        return nodes;
    }

    public static class Builder<T> {
        private final GraphIndex.View<T> view;
        private boolean concurrent;

        public Builder(GraphIndex.View<T> view) {
            this.view = view;
        }

        public Builder<T> withConcurrentUpdates() {
            this.concurrent = true;
            return this;
        }

        public GraphSearcher<T> build() {
            int size = this.view.getIdUpperBound();
            BitSet bits = this.concurrent ? new GrowableBitSet(size) : new SparseFixedBitSet(size);
            return new GraphSearcher<T>(this.view, bits);
        }
    }
}

