/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.util.Bits;
import java.io.IOException;

public interface GraphIndex<T>
extends AutoCloseable {
    public int size();

    public NodesIterator getNodes();

    public View<T> getView();

    public int maxDegree();

    default public int getIdUpperBound() {
        return this.size();
    }

    default public boolean containsNode(int nodeId) {
        return nodeId >= 0 && nodeId < this.size();
    }

    @Override
    public void close() throws IOException;

    public static <T> String prettyPrint(GraphIndex<T> graph) {
        StringBuilder sb = new StringBuilder();
        sb.append(graph);
        sb.append("\n");
        View<T> view = graph.getView();
        NodesIterator it = graph.getNodes();
        while (it.hasNext()) {
            int node = it.nextInt();
            sb.append("  ").append(node).append(" -> ");
            NodesIterator neighbors = view.getNeighborsIterator(node);
            while (neighbors.hasNext()) {
                sb.append(" ").append(neighbors.nextInt());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static interface View<T>
    extends AutoCloseable {
        public NodesIterator getNeighborsIterator(int var1);

        public int size();

        public int entryNode();

        public T getVector(int var1);

        public Bits liveNodes();

        default public int getIdUpperBound() {
            return this.size();
        }
    }
}

