/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbellis.jvector.disk;

import com.github.jbellis.jvector.disk.Io;
import com.github.jbellis.jvector.disk.RandomAccessReader;
import com.github.jbellis.jvector.disk.ReaderSupplier;
import com.github.jbellis.jvector.graph.GraphIndex;
import com.github.jbellis.jvector.graph.NodesIterator;
import com.github.jbellis.jvector.graph.RandomAccessVectorValues;
import com.github.jbellis.jvector.util.Accountable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;

public class OnDiskGraphIndex<T>
implements GraphIndex<T>,
AutoCloseable,
Accountable {
    private final ReaderSupplier readerSupplier;
    private final long neighborsOffset;
    private final int size;
    private final int entryNode;
    private final int M;
    private final int dimension;

    public OnDiskGraphIndex(ReaderSupplier readerSupplier, long offset) {
        this.readerSupplier = readerSupplier;
        this.neighborsOffset = offset + 16L;
        try (RandomAccessReader reader = readerSupplier.get();){
            reader.seek(offset);
            this.size = reader.readInt();
            this.dimension = reader.readInt();
            this.entryNode = reader.readInt();
            this.M = reader.readInt();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing OnDiskGraph at offset " + offset, e);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int maxEdgesPerNode() {
        return this.M;
    }

    public OnDiskView getView() {
        return new OnDiskView(this.readerSupplier.get());
    }

    @Override
    public NodesIterator getNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ramBytesUsed() {
        return 24L;
    }

    @Override
    public void close() {
        try {
            this.readerSupplier.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> void write(GraphIndex<T> graph, RandomAccessVectorValues<T> vectors, DataOutput out) throws IOException {
        assert (graph.size() == vectors.size()) : String.format("graph size %d != vectors size %d", graph.size(), vectors.size());
        GraphIndex.View<T> view = graph.getView();
        out.writeInt(graph.size());
        out.writeInt(vectors.dimension());
        out.writeInt(view.entryNode());
        out.writeInt(graph.maxEdgesPerNode());
        for (int node = 0; node < graph.size(); ++node) {
            int n;
            out.writeInt(node);
            Io.writeFloats(out, (float[])vectors.vectorValue(node));
            NodesIterator neighbors = view.getNeighborsIterator(node);
            out.writeInt(neighbors.size());
            for (n = 0; n < neighbors.size(); ++n) {
                out.writeInt(neighbors.nextInt());
            }
            assert (!neighbors.hasNext());
            while (n < graph.maxEdgesPerNode()) {
                out.writeInt(-1);
                ++n;
            }
        }
    }

    public class OnDiskView
    implements GraphIndex.View<T>,
    AutoCloseable {
        private final RandomAccessReader reader;

        public OnDiskView(RandomAccessReader reader) {
            this.reader = reader;
        }

        @Override
        public T getVector(int node) {
            try {
                long offset = OnDiskGraphIndex.this.neighborsOffset + (long)node * (4L + (long)OnDiskGraphIndex.this.dimension * 4L + 4L * (long)(OnDiskGraphIndex.this.M + 1)) + 4L;
                float[] vector = new float[OnDiskGraphIndex.this.dimension];
                this.reader.seek(offset);
                this.reader.readFully(vector);
                return vector;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public NodesIterator getNeighborsIterator(int node) {
            try {
                this.reader.seek(OnDiskGraphIndex.this.neighborsOffset + (long)(node + 1) * (4L + (long)OnDiskGraphIndex.this.dimension * 4L) + (long)node * 4L * (long)(OnDiskGraphIndex.this.M + 1));
                final int neighborCount = this.reader.readInt();
                assert (neighborCount <= OnDiskGraphIndex.this.M) : String.format("neighborCount %d > M %d", neighborCount, OnDiskGraphIndex.this.M);
                return new NodesIterator(neighborCount){
                    int currentNeighborsRead;
                    {
                        super(size);
                        this.currentNeighborsRead = 0;
                    }

                    @Override
                    public int nextInt() {
                        ++this.currentNeighborsRead;
                        try {
                            int ordinal = OnDiskView.this.reader.readInt();
                            assert (ordinal <= OnDiskGraphIndex.this.size) : String.format("ordinal %d > size %d", ordinal, this.size);
                            return ordinal;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currentNeighborsRead < neighborCount;
                    }
                };
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public int size() {
            return OnDiskGraphIndex.this.size();
        }

        @Override
        public int entryNode() {
            return OnDiskGraphIndex.this.entryNode;
        }

        @Override
        public void close() throws Exception {
            this.reader.close();
        }
    }
}

