/*
 * Decompiled with CFR 0.152.
 */
package io.github.javaezlib.javaez.extensions;

import io.github.javaezlib.javaez.backend.ErrorSystem;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class Security {
    public static String lockText(String text, String password) {
        try {
            byte b;
            int n;
            byte[] salt = Security.genSaltFromPassword(password);
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, 65536, 256);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            SecretKey originalKey = factory.generateSecret(keySpec);
            SecretKeySpec key = new SecretKeySpec(originalKey.getEncoded(), "AES");
            byte[] iv = new byte[16];
            new SecureRandom().nextBytes(iv);
            GCMParameterSpec gcmParamSpec = new GCMParameterSpec(128, iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)key, gcmParamSpec);
            byte[] encrypted = cipher.doFinal(text.getBytes(StandardCharsets.UTF_8));
            byte[] full = new byte[encrypted.length + iv.length];
            int index = 0;
            byte[] byArray = iv;
            int n2 = byArray.length;
            for (n = 0; n < n2; ++n) {
                full[index] = b = byArray[n];
                ++index;
            }
            byArray = encrypted;
            n2 = byArray.length;
            for (n = 0; n < n2; ++n) {
                full[index] = b = byArray[n];
                ++index;
            }
            return Base64.getEncoder().encodeToString(full);
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Could not lock text.");
            ex.printStackTrace();
            return null;
        }
    }

    public static String unlockText(String text, String password) {
        try {
            byte[] salt = Security.genSaltFromPassword(password);
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, 65536, 256);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            SecretKey originalKey = factory.generateSecret(keySpec);
            SecretKeySpec key = new SecretKeySpec(originalKey.getEncoded(), "AES");
            byte[] encrypted = Base64.getDecoder().decode(text);
            byte[] iv = Arrays.copyOfRange(encrypted, 0, 16);
            byte[] encData = Arrays.copyOfRange(encrypted, 16, encrypted.length);
            GCMParameterSpec gcmParamSpec = new GCMParameterSpec(128, iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)key, gcmParamSpec);
            byte[] decrypted = cipher.doFinal(encData);
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Could not unlock text.");
            return null;
        }
    }

    private static byte[] genSaltFromPassword(String password) {
        StringBuilder sb = new StringBuilder();
        sb.append(password);
        sb.reverse();
        String reversed = sb.toString();
        return reversed.getBytes(StandardCharsets.UTF_8);
    }
}

