/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamsesso.jsonlogic;

import io.github.jamsesso.jsonlogic.JsonLogicException;
import io.github.jamsesso.jsonlogic.ast.JsonLogicNode;
import io.github.jamsesso.jsonlogic.ast.JsonLogicParser;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluator;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.AllExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.ArrayHasExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.ConcatenateExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.EqualityExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.FilterExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.IfExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.InExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.InequalityExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.LogExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.LogicExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.MapExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.MathExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.MergeExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.MissingExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.NotExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.NumericComparisonExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.PreEvaluatedArgumentsExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.ReduceExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.StrictEqualityExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.StrictInequalityExpression;
import io.github.jamsesso.jsonlogic.evaluator.expressions.SubstringExpression;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class JsonLogic {
    private final Map<String, JsonLogicNode> parseCache = new ConcurrentHashMap<String, JsonLogicNode>();
    private final Map<String, JsonLogicExpression> expressions = new ConcurrentHashMap<String, JsonLogicExpression>();
    private JsonLogicEvaluator evaluator;

    public JsonLogic() {
        this.addOperation(MathExpression.ADD);
        this.addOperation(MathExpression.SUBTRACT);
        this.addOperation(MathExpression.MULTIPLY);
        this.addOperation(MathExpression.DIVIDE);
        this.addOperation(MathExpression.MODULO);
        this.addOperation(MathExpression.MIN);
        this.addOperation(MathExpression.MAX);
        this.addOperation(NumericComparisonExpression.GT);
        this.addOperation(NumericComparisonExpression.GTE);
        this.addOperation(NumericComparisonExpression.LT);
        this.addOperation(NumericComparisonExpression.LTE);
        this.addOperation(IfExpression.IF);
        this.addOperation(IfExpression.TERNARY);
        this.addOperation(EqualityExpression.INSTANCE);
        this.addOperation(InequalityExpression.INSTANCE);
        this.addOperation(StrictEqualityExpression.INSTANCE);
        this.addOperation(StrictInequalityExpression.INSTANCE);
        this.addOperation(NotExpression.SINGLE);
        this.addOperation(NotExpression.DOUBLE);
        this.addOperation(LogicExpression.AND);
        this.addOperation(LogicExpression.OR);
        this.addOperation(LogExpression.STDOUT);
        this.addOperation(MapExpression.INSTANCE);
        this.addOperation(FilterExpression.INSTANCE);
        this.addOperation(ReduceExpression.INSTANCE);
        this.addOperation(AllExpression.INSTANCE);
        this.addOperation(ArrayHasExpression.SOME);
        this.addOperation(ArrayHasExpression.NONE);
        this.addOperation(MergeExpression.INSTANCE);
        this.addOperation(InExpression.INSTANCE);
        this.addOperation(ConcatenateExpression.INSTANCE);
        this.addOperation(SubstringExpression.INSTANCE);
        this.addOperation(MissingExpression.ALL);
        this.addOperation(MissingExpression.SOME);
    }

    public JsonLogic addOperation(final String name, final Function<Object[], Object> function) {
        return this.addOperation(new PreEvaluatedArgumentsExpression(){

            @Override
            public Object evaluate(List arguments, Object data, String jsonPath) {
                return function.apply(arguments.toArray());
            }

            @Override
            public String key() {
                return name;
            }
        });
    }

    public JsonLogic addOperation(JsonLogicExpression expression) {
        this.expressions.put(expression.key(), expression);
        this.evaluator = null;
        return this;
    }

    public Object apply(String json, Object data) throws JsonLogicException {
        if (!this.parseCache.containsKey(json)) {
            this.parseCache.put(json, JsonLogicParser.parse(json));
        }
        if (this.evaluator == null) {
            this.evaluator = new JsonLogicEvaluator(this.expressions);
        }
        return this.evaluator.evaluate(this.parseCache.get(json), data, "$");
    }

    public static boolean truthy(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            if (value instanceof Double) {
                Double d = (Double)value;
                if (d.isNaN()) {
                    return false;
                }
                if (d.isInfinite()) {
                    return true;
                }
            }
            if (value instanceof Float) {
                Float f = (Float)value;
                if (f.isNaN()) {
                    return false;
                }
                if (f.isInfinite()) {
                    return true;
                }
            }
            return ((Number)value).doubleValue() != 0.0;
        }
        if (value instanceof String) {
            return !((String)value).isEmpty();
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) > 0;
        }
        return true;
    }
}

