/*
 * Decompiled with CFR 0.152.
 */
package io.github.inflationx.calligraphy3;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import androidx.appcompat.widget.Toolbar;
import io.github.inflationx.calligraphy3.CalligraphyConfig;
import io.github.inflationx.calligraphy3.CalligraphyUtils;
import io.github.inflationx.calligraphy3.FontMapper;
import io.github.inflationx.calligraphy3.HasTypeface;
import io.github.inflationx.calligraphy3.R;
import io.github.inflationx.calligraphy3.ReflectionUtils;
import io.github.inflationx.calligraphy3.TypefaceUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

class Calligraphy {
    private static final String ACTION_BAR_TITLE = "action_bar_title";
    private static final String ACTION_BAR_SUBTITLE = "action_bar_subtitle";
    private final CalligraphyConfig mCalligraphyConfig;
    private final int[] mAttributeId;

    protected int[] getStyleForTextView(TextView view) {
        int[] styleIds = new int[]{-1, -1};
        if (Calligraphy.isActionBarTitle(view)) {
            styleIds[0] = 16843470;
            styleIds[1] = 16843512;
        } else if (Calligraphy.isActionBarSubTitle(view)) {
            styleIds[0] = 16843470;
            styleIds[1] = 16843513;
        }
        if (styleIds[0] == -1) {
            styleIds[0] = this.mCalligraphyConfig.getClassStyles().containsKey(view.getClass()) ? this.mCalligraphyConfig.getClassStyles().get(view.getClass()) : 16842804;
        }
        return styleIds;
    }

    @SuppressLint(value={"NewApi"})
    protected static boolean isActionBarTitle(TextView view) {
        if (Calligraphy.matchesResourceIdName((View)view, ACTION_BAR_TITLE)) {
            return true;
        }
        if (Calligraphy.parentIsToolbarV7((View)view)) {
            Toolbar parent = (Toolbar)view.getParent();
            return TextUtils.equals((CharSequence)parent.getTitle(), (CharSequence)view.getText());
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    protected static boolean isActionBarSubTitle(TextView view) {
        if (Calligraphy.matchesResourceIdName((View)view, ACTION_BAR_SUBTITLE)) {
            return true;
        }
        if (Calligraphy.parentIsToolbarV7((View)view)) {
            Toolbar parent = (Toolbar)view.getParent();
            return TextUtils.equals((CharSequence)parent.getSubtitle(), (CharSequence)view.getText());
        }
        return false;
    }

    protected static boolean parentIsToolbarV7(View view) {
        return CalligraphyUtils.canCheckForV7Toolbar() && view.getParent() != null && view.getParent() instanceof Toolbar;
    }

    protected static boolean matchesResourceIdName(View view, String matches) {
        if (view.getId() == -1) {
            return false;
        }
        String resourceEntryName = view.getResources().getResourceEntryName(view.getId());
        return resourceEntryName.equalsIgnoreCase(matches);
    }

    public Calligraphy(CalligraphyConfig calligraphyConfig) {
        this.mCalligraphyConfig = calligraphyConfig;
        this.mAttributeId = new int[]{calligraphyConfig.getAttrId()};
    }

    public View onViewCreated(View view, Context context, AttributeSet attrs) {
        if (view != null && view.getTag(R.id.calligraphy_tag_id) != Boolean.TRUE) {
            this.onViewCreatedInternal(view, context, attrs);
            view.setTag(R.id.calligraphy_tag_id, (Object)Boolean.TRUE);
        }
        return view;
    }

    void onViewCreatedInternal(View view, Context context, AttributeSet attrs) {
        String textViewFont;
        if (view instanceof TextView) {
            if (TypefaceUtils.isLoaded(((TextView)view).getTypeface())) {
                return;
            }
            textViewFont = this.resolveFontPath(context, attrs);
            if (TextUtils.isEmpty((CharSequence)textViewFont)) {
                int[] styleForTextView = this.getStyleForTextView((TextView)view);
                textViewFont = styleForTextView[1] != -1 ? CalligraphyUtils.pullFontPathFromTheme(context, styleForTextView[0], styleForTextView[1], this.mAttributeId) : CalligraphyUtils.pullFontPathFromTheme(context, styleForTextView[0], this.mAttributeId);
            }
            textViewFont = this.applyFontMapper(textViewFont);
            boolean deferred = Calligraphy.matchesResourceIdName(view, ACTION_BAR_TITLE) || Calligraphy.matchesResourceIdName(view, ACTION_BAR_SUBTITLE);
            CalligraphyUtils.applyFontToTextView(context, (TextView)view, this.mCalligraphyConfig, textViewFont, deferred);
        }
        if (CalligraphyUtils.canCheckForV7Toolbar() && view instanceof Toolbar) {
            Toolbar toolbar = (Toolbar)view;
            toolbar.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new ToolbarLayoutListener(this, context, toolbar));
        }
        if (view instanceof HasTypeface) {
            textViewFont = this.resolveFontPath(context, attrs);
            Typeface typeface = this.getDefaultTypeface(context, textViewFont = this.applyFontMapper(textViewFont));
            if (typeface != null) {
                ((HasTypeface)view).setTypeface(typeface);
            }
        } else if (this.mCalligraphyConfig.isCustomViewTypefaceSupport() && this.mCalligraphyConfig.isCustomViewHasTypeface(view)) {
            Method setTypeface = ReflectionUtils.getMethod(view.getClass(), "setTypeface");
            String fontPath = this.resolveFontPath(context, attrs);
            fontPath = this.applyFontMapper(fontPath);
            Typeface typeface = this.getDefaultTypeface(context, fontPath);
            if (setTypeface != null && typeface != null) {
                ReflectionUtils.invokeMethod(view, setTypeface, typeface);
            }
        }
    }

    private Typeface getDefaultTypeface(Context context, String fontPath) {
        if (TextUtils.isEmpty((CharSequence)fontPath)) {
            fontPath = this.mCalligraphyConfig.getFontPath();
        }
        if (!TextUtils.isEmpty((CharSequence)fontPath)) {
            return TypefaceUtils.load(context.getAssets(), fontPath);
        }
        return null;
    }

    private String resolveFontPath(Context context, AttributeSet attrs) {
        String textViewFont = CalligraphyUtils.pullFontPathFromView(context, attrs, this.mAttributeId);
        if (TextUtils.isEmpty((CharSequence)textViewFont)) {
            textViewFont = CalligraphyUtils.pullFontPathFromStyle(context, attrs, this.mAttributeId);
        }
        if (TextUtils.isEmpty((CharSequence)textViewFont)) {
            textViewFont = CalligraphyUtils.pullFontPathFromTextAppearance(context, attrs, this.mAttributeId);
        }
        return textViewFont;
    }

    private String applyFontMapper(String textViewFont) {
        FontMapper fontMapper = this.mCalligraphyConfig.getFontMapper();
        return fontMapper != null ? fontMapper.map(textViewFont) : textViewFont;
    }

    private static class ToolbarLayoutListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        static String BLANK = " ";
        private final WeakReference<Calligraphy> mCalligraphyFactory;
        private final WeakReference<Context> mContextRef;
        private final WeakReference<Toolbar> mToolbarReference;
        private final CharSequence originalSubTitle;

        private ToolbarLayoutListener(Calligraphy calligraphy, Context context, Toolbar toolbar) {
            this.mCalligraphyFactory = new WeakReference<Calligraphy>(calligraphy);
            this.mContextRef = new WeakReference<Context>(context);
            this.mToolbarReference = new WeakReference<Toolbar>(toolbar);
            this.originalSubTitle = toolbar.getSubtitle();
            toolbar.setSubtitle((CharSequence)BLANK);
        }

        @TargetApi(value=16)
        public void onGlobalLayout() {
            Toolbar toolbar = (Toolbar)this.mToolbarReference.get();
            Context context = (Context)this.mContextRef.get();
            Calligraphy factory = (Calligraphy)this.mCalligraphyFactory.get();
            if (toolbar == null) {
                return;
            }
            if (factory == null || context == null) {
                this.removeSelf(toolbar);
                return;
            }
            int childCount = toolbar.getChildCount();
            if (childCount != 0) {
                for (int i = 0; i < childCount; ++i) {
                    factory.onViewCreated(toolbar.getChildAt(i), context, null);
                }
            }
            this.removeSelf(toolbar);
            toolbar.setSubtitle(this.originalSubTitle);
        }

        private void removeSelf(Toolbar toolbar) {
            if (Build.VERSION.SDK_INT < 16) {
                toolbar.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                toolbar.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
    }
}

