/*
 * Decompiled with CFR 0.152.
 */
package io.github.inflationx.calligraphy3;

import android.support.v7.widget.AppCompatAutoCompleteTextView;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.AppCompatCheckBox;
import android.support.v7.widget.AppCompatCheckedTextView;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.AppCompatMultiAutoCompleteTextView;
import android.support.v7.widget.AppCompatRadioButton;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextUtils;
import android.view.View;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.MultiAutoCompleteTextView;
import android.widget.RadioButton;
import android.widget.TextView;
import android.widget.ToggleButton;
import io.github.inflationx.calligraphy3.CalligraphyUtils;
import io.github.inflationx.calligraphy3.FontMapper;
import io.github.inflationx.calligraphy3.R;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CalligraphyConfig {
    private static final Map<Class<? extends TextView>, Integer> DEFAULT_STYLES = new HashMap<Class<? extends TextView>, Integer>();
    private final boolean mIsFontSet;
    private final String mFontPath;
    private final int mAttrId;
    private final boolean mCustomViewTypefaceSupport;
    private final Map<Class<? extends TextView>, Integer> mClassStyleAttributeMap;
    private final Set<Class<?>> hasTypefaceViews;
    private final FontMapper mFontMapper;

    private static void addAppCompatViews() {
        DEFAULT_STYLES.put(AppCompatTextView.class, 16842884);
        DEFAULT_STYLES.put(AppCompatButton.class, 16842824);
        DEFAULT_STYLES.put(AppCompatEditText.class, 16842862);
        DEFAULT_STYLES.put(AppCompatAutoCompleteTextView.class, 16842859);
        DEFAULT_STYLES.put(AppCompatMultiAutoCompleteTextView.class, 16842859);
        DEFAULT_STYLES.put(AppCompatCheckBox.class, 16842860);
        DEFAULT_STYLES.put(AppCompatRadioButton.class, 16842878);
        DEFAULT_STYLES.put(AppCompatCheckedTextView.class, 16843720);
    }

    private CalligraphyConfig(Builder builder) {
        this.mIsFontSet = builder.isFontSet;
        this.mFontPath = builder.fontAssetPath;
        this.mAttrId = builder.attrId;
        this.mCustomViewTypefaceSupport = builder.customViewTypefaceSupport;
        HashMap<Class<? extends TextView>, Integer> tempMap = new HashMap<Class<? extends TextView>, Integer>(DEFAULT_STYLES);
        tempMap.putAll(builder.mStyleClassMap);
        this.mClassStyleAttributeMap = Collections.unmodifiableMap(tempMap);
        this.hasTypefaceViews = Collections.unmodifiableSet(builder.mHasTypefaceClasses);
        this.mFontMapper = builder.fontMapper;
    }

    public String getFontPath() {
        return this.mFontPath;
    }

    boolean isFontSet() {
        return this.mIsFontSet;
    }

    public boolean isCustomViewTypefaceSupport() {
        return this.mCustomViewTypefaceSupport;
    }

    public boolean isCustomViewHasTypeface(View view) {
        return this.hasTypefaceViews.contains(view.getClass());
    }

    Map<Class<? extends TextView>, Integer> getClassStyles() {
        return this.mClassStyleAttributeMap;
    }

    public int getAttrId() {
        return this.mAttrId;
    }

    public FontMapper getFontMapper() {
        return this.mFontMapper;
    }

    static {
        DEFAULT_STYLES.put(TextView.class, 16842884);
        DEFAULT_STYLES.put(Button.class, 16842824);
        DEFAULT_STYLES.put(EditText.class, 16842862);
        DEFAULT_STYLES.put(AutoCompleteTextView.class, 16842859);
        DEFAULT_STYLES.put(MultiAutoCompleteTextView.class, 16842859);
        DEFAULT_STYLES.put(CheckBox.class, 16842860);
        DEFAULT_STYLES.put(RadioButton.class, 16842878);
        DEFAULT_STYLES.put(ToggleButton.class, 16842827);
        if (CalligraphyUtils.canAddV7AppCompatViews()) {
            CalligraphyConfig.addAppCompatViews();
        }
    }

    public static class Builder {
        public static final int INVALID_ATTR_ID = -1;
        private boolean customViewTypefaceSupport = false;
        private int attrId = R.attr.fontPath;
        private boolean isFontSet = false;
        private String fontAssetPath = null;
        private Map<Class<? extends TextView>, Integer> mStyleClassMap = new HashMap<Class<? extends TextView>, Integer>();
        private Set<Class<?>> mHasTypefaceClasses = new HashSet();
        private FontMapper fontMapper;

        public Builder setFontAttrId(int fontAssetAttrId) {
            this.attrId = fontAssetAttrId;
            return this;
        }

        public Builder setDefaultFontPath(String defaultFontAssetPath) {
            this.isFontSet = !TextUtils.isEmpty((CharSequence)defaultFontAssetPath);
            this.fontAssetPath = defaultFontAssetPath;
            return this;
        }

        public Builder addCustomStyle(Class<? extends TextView> styleClass, int styleResourceAttribute) {
            if (styleClass == null || styleResourceAttribute == 0) {
                return this;
            }
            this.mStyleClassMap.put(styleClass, styleResourceAttribute);
            return this;
        }

        public Builder addCustomViewWithSetTypeface(Class<?> clazz) {
            this.customViewTypefaceSupport = true;
            this.mHasTypefaceClasses.add(clazz);
            return this;
        }

        public Builder setFontMapper(FontMapper fontMapper) {
            this.fontMapper = fontMapper;
            return this;
        }

        public CalligraphyConfig build() {
            this.isFontSet = !TextUtils.isEmpty((CharSequence)this.fontAssetPath);
            return new CalligraphyConfig(this);
        }
    }
}

