/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sude;

import nl.altindag.sude.Logger;
import nl.altindag.sude.logger.JavaUtilLoggingLogger;
import nl.altindag.sude.logger.Log4j2Logger;
import nl.altindag.sude.logger.Slf4jLogger;

public class LoggerFactory {
    private LoggerFactory() {
    }

    public static <T> Logger getLogger(Class<T> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        try {
            return Slf4jLogger.getLogger(name);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            try {
                return Log4j2Logger.getLogger(name);
            }
            catch (NoClassDefFoundError noClassDefFoundError2) {
                return JavaUtilLoggingLogger.getLogger(name);
            }
        }
    }
}

