/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.util.function.Supplier;
import nl.altindag.ssl.exception.GenericException;
import nl.altindag.ssl.util.Function;

@FunctionalInterface
public interface Box<T> {
    public ValueHolder<T> valueHolder();

    public static <T> Box<T> of(T value) {
        return () -> ValueHolder.wrap(() -> value);
    }

    default public <R> Box<R> map(Function<? super T, ? extends R> mapper) {
        return () -> ValueHolder.wrap(() -> {
            T value = this.valueHolder().get();
            try {
                return mapper.apply((T)value);
            }
            catch (Exception e) {
                throw new GenericException(e);
            }
        });
    }

    default public T get() {
        return this.valueHolder().get();
    }

    @FunctionalInterface
    public static interface ValueHolder<T> {
        public Supplier<T> valueSupplier();

        default public T get() {
            return this.valueSupplier().get();
        }

        public static <U> ValueHolder<U> wrap(Supplier<U> supplier) {
            return () -> supplier;
        }
    }
}

